/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.binary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarDeserializationException;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.binary.BinaryDollarOperator;
import de.siphalor.nbtcrafting3.util.NumberUtil;
import java.util.function.BiFunction;

public class NumericBinaryDollarOperator
extends BinaryDollarOperator {
    private final BiFunction<Number, Number, Number> function;

    private NumericBinaryDollarOperator(BiFunction<Number, Number, Number> function, DollarPart first, DollarPart second) {
        super(first, second);
        this.function = function;
    }

    public static DollarPart of(BiFunction<Number, Number, Number> function, DollarPart first, DollarPart second) throws DollarDeserializationException {
        return NumericBinaryDollarOperator.shortCircuitConstant(new NumericBinaryDollarOperator(function, first, second));
    }

    public static DollarPart differenceOf(DollarPart first, DollarPart second) throws DollarDeserializationException {
        return NumericBinaryDollarOperator.of(NumberUtil::difference, first, second);
    }

    public static DollarPart quotientOf(DollarPart first, DollarPart second) throws DollarDeserializationException {
        return NumericBinaryDollarOperator.of(NumberUtil::quotient, first, second);
    }

    @Override
    public Object apply(Object first, Object second) throws DollarEvaluationException {
        if (first == null) {
            first = 0;
        }
        if (second == null) {
            second = 0;
        }
        if (!(first instanceof Number)) {
            throw new DollarEvaluationException(DollarUtil.asString(first) + " is not a number");
        }
        if (!(second instanceof Number)) {
            throw new DollarEvaluationException(DollarUtil.asString(second) + " is not a number");
        }
        return this.function.apply((Number)first, (Number)second);
    }
}

