/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.dollar.part.ternary;

import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import de.siphalor.nbtcrafting3.dollar.part.value.ConstantDollarPart;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;

public class ConditionDollarOperator
implements DollarPart {
    private final DollarPart condition;
    private final DollarPart thenPart;
    private final DollarPart elsePart;

    private ConditionDollarOperator(DollarPart condition, DollarPart thenPart, DollarPart elsePart) {
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    public static DollarPart of(DollarPart condition, DollarPart thenPart, DollarPart elsePart) {
        if (condition instanceof ConstantDollarPart) {
            if (DollarUtil.asBoolean(((ConstantDollarPart)condition).getConstantValue())) {
                return thenPart;
            }
            return elsePart;
        }
        return new ConditionDollarOperator(condition, thenPart, elsePart);
    }

    @Override
    public Object evaluate(ReferenceResolver referenceResolver) throws DollarEvaluationException {
        if (DollarUtil.asBoolean(this.condition.evaluate(referenceResolver))) {
            return this.thenPart.evaluate(referenceResolver);
        }
        return this.elsePart.evaluate(referenceResolver);
    }
}

