/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.nbt.NbtException;
import de.siphalor.nbtcrafting3.api.nbt.NbtIterator;
import de.siphalor.nbtcrafting3.api.nbt.NbtNumberRange;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.DollarExtractor;
import de.siphalor.nbtcrafting3.dollar.DollarUtil;
import de.siphalor.nbtcrafting3.dollar.exception.DollarEvaluationException;
import de.siphalor.nbtcrafting3.dollar.exception.UnresolvedDollarReferenceException;
import de.siphalor.nbtcrafting3.dollar.part.DollarPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;

public class IngredientEntryCondition {
    public static final IngredientEntryCondition EMPTY = new IngredientEntryCondition(NbtUtil.EMPTY_COMPOUND, NbtUtil.EMPTY_COMPOUND);
    public class_2487 requiredElements;
    public class_2487 deniedElements;
    public List<class_3545<String, DollarPart>> dollarPredicates;
    private class_2487 previewTag;

    protected IngredientEntryCondition() {
        this.requiredElements = NbtUtil.EMPTY_COMPOUND;
        this.deniedElements = NbtUtil.EMPTY_COMPOUND;
        this.dollarPredicates = null;
    }

    public IngredientEntryCondition(class_2487 requiredElements, class_2487 deniedElements) {
        this.requiredElements = requiredElements;
        this.deniedElements = deniedElements;
    }

    public boolean matches(class_1799 stack) {
        if (!stack.method_7985()) {
            return this.requiredElements.method_33133();
        }
        class_2487 tag = stack.method_7969();
        if (!this.deniedElements.method_33133() && NbtUtil.compoundsOverlap(tag, this.deniedElements)) {
            return false;
        }
        if (!this.requiredElements.method_33133() && !NbtUtil.isCompoundContained(this.requiredElements, tag)) {
            return false;
        }
        if (this.dollarPredicates != null && !this.dollarPredicates.isEmpty()) {
            for (class_3545<String, DollarPart> predicate : this.dollarPredicates) {
                try {
                    if (DollarUtil.asBoolean(((DollarPart)predicate.method_15441()).evaluate(ref -> {
                        if ("$".equals(ref)) {
                            return tag;
                        }
                        throw new UnresolvedDollarReferenceException(ref);
                    }))) continue;
                    return false;
                }
                catch (DollarEvaluationException e) {
                    NbtCrafting.logWarn("Failed to evaluate dollar predicate (" + (String)predicate.method_15442() + "): " + e.getMessage());
                }
            }
        }
        return true;
    }

    public void addToJson(JsonObject json) {
        if (this.requiredElements.method_10546() > 0) {
            json.add("require", NbtUtil.toJson((class_2520)this.requiredElements));
        }
        if (this.deniedElements.method_10546() > 0) {
            json.add("deny", NbtUtil.toJson((class_2520)this.deniedElements));
        }
        if (this.dollarPredicates != null && !this.dollarPredicates.isEmpty()) {
            JsonArray array = new JsonArray();
            for (class_3545<String, DollarPart> condition : this.dollarPredicates) {
                array.add((String)condition.method_15442());
            }
            json.add("conditions", (JsonElement)array);
        }
    }

    public class_2487 getPreviewTag() {
        if (this.previewTag == null) {
            this.previewTag = this.requiredElements.method_10553();
            ArrayList dollarRangeKeys = new ArrayList();
            NbtIterator.iterateTags((class_2520)this.previewTag, (path, key, tag) -> {
                String text;
                if (NbtUtil.isString(tag) && (text = NbtUtil.asString(tag)).startsWith("$")) {
                    dollarRangeKeys.add(new class_3545((Object)NbtUtil.splitPath(path + key), (Object)NbtNumberRange.ofString(text.substring(1)).getExample()));
                }
                return NbtIterator.Action.RECURSE;
            });
            for (class_3545 dollarRangeKey : dollarRangeKeys) {
                try {
                    NbtUtil.put((class_2520)this.previewTag, (String[])dollarRangeKey.method_15442(), (class_2520)dollarRangeKey.method_15441());
                }
                catch (NbtException e) {
                    NbtCrafting.logWarn("Failed to set dollar range value " + dollarRangeKey.method_15441() + " for key " + String.join((CharSequence)".", (CharSequence[])dollarRangeKey.method_15442()) + " in preview tag " + this.previewTag);
                }
            }
        }
        return this.previewTag;
    }

    public static IngredientEntryCondition fromJson(JsonObject json) {
        class_2960 potion;
        IngredientEntryCondition condition = new IngredientEntryCondition();
        boolean flatObject = true;
        if (json.has("require")) {
            if (!json.get("require").isJsonObject()) {
                throw new JsonParseException("data.require must be an object");
            }
            condition.requiredElements = (class_2487)NbtUtil.asTag((JsonElement)json.getAsJsonObject("require"));
            flatObject = false;
        }
        if (json.has("potion")) {
            potion = new class_2960(class_3518.method_15265((JsonObject)json, (String)"potion"));
            if (class_2378.field_11143.method_17966(potion).isPresent()) {
                if (condition.requiredElements == NbtUtil.EMPTY_COMPOUND) {
                    condition.requiredElements = new class_2487();
                }
                condition.requiredElements.method_10582("Potion", potion.toString());
            } else {
                new JsonSyntaxException("Unknown potion '" + potion + "'").printStackTrace();
            }
            flatObject = false;
        }
        if (json.has("potion")) {
            potion = new class_2960(class_3518.method_15265((JsonObject)json, (String)"potion"));
            if (class_2378.field_11143.method_17966(potion).isPresent()) {
                if (condition.requiredElements == NbtUtil.EMPTY_COMPOUND) {
                    condition.requiredElements = new class_2487();
                }
                condition.requiredElements.method_10582("Potion", potion.toString());
            } else {
                new JsonSyntaxException("Unknown potion '" + potion + "'").printStackTrace();
            }
            flatObject = false;
        }
        if (json.has("deny")) {
            if (!json.get("deny").isJsonObject()) {
                throw new JsonParseException("data.deny must be an object");
            }
            condition.deniedElements = (class_2487)NbtUtil.asTag((JsonElement)json.getAsJsonObject("deny"));
            flatObject = false;
        }
        if (json.has("conditions")) {
            if (!json.get("conditions").isJsonArray()) {
                throw new JsonParseException("data.conditions must be an array");
            }
            JsonArray array = json.getAsJsonArray("conditions");
            ArrayList<class_3545<String, DollarPart>> predicates = new ArrayList<class_3545<String, DollarPart>>(array.size());
            for (JsonElement jsonElement : array) {
                if (!class_3518.method_15286((JsonElement)jsonElement)) {
                    throw new JsonParseException("data.conditions must be an array of strings");
                }
                predicates.add((class_3545<String, DollarPart>)new class_3545((Object)jsonElement.getAsString(), (Object)DollarExtractor.parse(jsonElement.getAsString())));
            }
            condition.dollarPredicates = predicates;
            flatObject = false;
        }
        if (flatObject) {
            condition.requiredElements = (class_2487)NbtUtil.asTag((JsonElement)json);
        }
        return condition;
    }

    public void write(class_2540 buf) {
        buf.method_10794(this.requiredElements);
        buf.method_10794(this.deniedElements);
    }

    public static IngredientEntryCondition read(class_2540 buf) {
        return new IngredientEntryCondition(buf.method_10798(), buf.method_10798());
    }
}

