/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.nbtcrafting3.NbtCrafting;
import de.siphalor.nbtcrafting3.api.JsonPreprocessor;
import de.siphalor.nbtcrafting3.api.nbt.NbtUtil;
import de.siphalor.nbtcrafting3.dollar.reference.ReferenceResolver;
import de.siphalor.nbtcrafting3.ingredient.IIngredient;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntry;
import de.siphalor.nbtcrafting3.ingredient.IngredientEntryCondition;
import de.siphalor.nbtcrafting3.ingredient.IngredientMultiStackEntry;
import de.siphalor.nbtcrafting3.ingredient.IngredientStackEntry;
import de.siphalor.nbtcrafting3.util.duck.ICloneable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1856.class}, priority=990)
public abstract class MixinIngredient
implements IIngredient,
ICloneable {
    @Shadow
    private class_1799[] field_9018;
    @Unique
    private IngredientEntry[] advancedEntries;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(Stream stream, CallbackInfo ci) {
        this.advancedEntries = null;
    }

    @Inject(method={"cacheMatchingStacks"}, at={@At(value="HEAD")}, cancellable=true)
    private void createStackArray(CallbackInfo callbackInfo) {
        if (this.advancedEntries != null) {
            callbackInfo.cancel();
            if (this.field_9018 == null || this.field_9018.length == 0) {
                this.field_9018 = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? (class_1799[])Arrays.stream(this.advancedEntries).flatMap(entry -> entry.getPreviewStacks(true).stream()).distinct().toArray(class_1799[]::new) : (class_1799[])Arrays.stream(this.advancedEntries).flatMap(entry -> entry.getPreviewStacks(false).stream()).distinct().toArray(class_1799[]::new);
                if (this.field_9018.length == 0) {
                    this.field_9018 = new class_1799[]{class_1799.field_8037};
                }
            }
        }
    }

    @Inject(method={"test"}, at={@At(value="HEAD")}, cancellable=true)
    public void matches(class_1799 stack, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (stack == null) {
            callbackInfoReturnable.setReturnValue((Object)false);
            return;
        }
        if (this.advancedEntries != null) {
            if (this.advancedEntries.length == 0) {
                callbackInfoReturnable.setReturnValue((Object)stack.method_7960());
                return;
            }
            for (IngredientEntry advancedEntry : this.advancedEntries) {
                if (!advancedEntry.matches(stack)) continue;
                callbackInfoReturnable.setReturnValue((Object)true);
                return;
            }
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"write"}, at={@At(value="HEAD")}, cancellable=true)
    public void write(class_2540 buf, CallbackInfo callbackInfo) {
        if (NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            if (this.advancedEntries != null && this.advancedEntries.length != 0) {
                buf.method_10804(this.advancedEntries.length);
                for (IngredientEntry entry : this.advancedEntries) {
                    buf.writeBoolean(entry instanceof IngredientMultiStackEntry);
                    entry.write(buf);
                }
                callbackInfo.cancel();
            } else {
                buf.method_10804(-1);
            }
        }
    }

    @Inject(method={"toJson"}, at={@At(value="HEAD")}, cancellable=true)
    public void toJson(CallbackInfoReturnable<JsonElement> callbackInfoReturnable) {
        if (this.advancedEntries != null) {
            if (this.advancedEntries.length == 1) {
                callbackInfoReturnable.setReturnValue((Object)this.advancedEntries[0].toJson());
                return;
            }
            JsonArray array = new JsonArray();
            for (IngredientEntry advancedEntry : this.advancedEntries) {
                array.add(advancedEntry.toJson());
            }
            callbackInfoReturnable.setReturnValue((Object)array);
        }
    }

    @Inject(method={"isEmpty"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (this.advancedEntries != null) {
            callbackInfoReturnable.setReturnValue((Object)(this.advancedEntries.length == 0 ? 1 : 0));
        }
    }

    @Unique
    private static class_1856 ofAdvancedEntries(Stream<? extends IngredientEntry> entries) {
        if (entries == null) {
            NbtCrafting.logError("Internal error: can't construct ingredient from null entry stream!");
        }
        try {
            class_1856 ingredient = (class_1856)((ICloneable)class_1856.field_9017).clone();
            ((IIngredient)ingredient).nbtCrafting$setAdvancedEntries(entries);
            return ingredient;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return class_1856.field_9017;
        }
    }

    @Inject(method={"fromPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromPacket(class_2540 buf, CallbackInfoReturnable<class_1856> cir) {
        int length;
        if (NbtCrafting.isAdvancedIngredientSerializationEnabled() && (length = buf.method_10816()) >= 0) {
            ArrayList<IngredientEntry> entries = new ArrayList<IngredientEntry>(length);
            for (int i = 0; i < length; ++i) {
                if (buf.readBoolean()) {
                    entries.add(IngredientMultiStackEntry.read(buf));
                    continue;
                }
                entries.add(IngredientStackEntry.read(buf));
            }
            cir.setReturnValue((Object)MixinIngredient.ofAdvancedEntries(entries.stream()));
        }
    }

    @Inject(method={"fromJson"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromJson(JsonElement element, CallbackInfoReturnable<class_1856> callbackInfoReturnable) {
        if (!NbtCrafting.isAdvancedIngredientSerializationEnabled()) {
            return;
        }
        if (element == null || element.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (element.isJsonObject()) {
            if (element.getAsJsonObject().has("data") || element.getAsJsonObject().has("remainder") || element.getAsJsonObject().has("potion")) {
                callbackInfoReturnable.setReturnValue((Object)MixinIngredient.ofAdvancedEntries(Stream.of(MixinIngredient.advancedEntryFromJson(element.getAsJsonObject()))));
            }
        } else if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            boolean containsCustomData = false;
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject;
                if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has("data") && !jsonObject.has("remainder") && !jsonObject.has("potion")) continue;
                containsCustomData = true;
                break;
            }
            if (containsCustomData) {
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                callbackInfoReturnable.setReturnValue((Object)MixinIngredient.ofAdvancedEntries(StreamSupport.stream(jsonArray.spliterator(), false).map(e -> MixinIngredient.advancedEntryFromJson(class_3518.method_15295((JsonElement)e, (String)"item")))));
            }
        }
    }

    @Unique
    private static IngredientEntry advancedEntryFromJson(JsonObject jsonObject) {
        if (jsonObject.has("item") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item or a potion, not both");
        }
        if (jsonObject.has("item")) {
            class_2960 itemId = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"item"));
            try {
                class_1792 item = (class_1792)class_2378.field_11142.method_17966(itemId).orElseThrow(() -> {
                    throw new JsonSyntaxException("Unknown item '" + itemId + "'");
                });
                IngredientStackEntry entry = new IngredientStackEntry(class_2378.field_11142.method_10206((Object)item), MixinIngredient.loadIngredientEntryCondition(jsonObject));
                if (jsonObject.has("remainder")) {
                    entry.setRecipeRemainder(class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"remainder")));
                }
                return entry;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        if (jsonObject.has("tag")) {
            class_2960 tagId = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"tag"));
            class_3494 tag = class_3489.method_15106().method_30210(tagId);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + tagId + "'");
            }
            IngredientMultiStackEntry entry = new IngredientMultiStackEntry(tag.method_15138().stream().map(arg_0 -> ((class_2348)class_2378.field_11142).method_10206(arg_0)).collect(Collectors.toList()), MixinIngredient.loadIngredientEntryCondition(jsonObject));
            entry.setTag(tagId.toString());
            if (jsonObject.has("remainder")) {
                entry.setRecipeRemainder(class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"remainder")));
            }
            return entry;
        }
        if (jsonObject.has("potion")) {
            IngredientEntryCondition condition = MixinIngredient.loadIngredientEntryCondition(jsonObject);
            IngredientStackEntry entry = new IngredientStackEntry(class_2378.field_11142.method_10206((Object)class_1802.field_8574), condition);
            if (jsonObject.has("remainder")) {
                entry.setRecipeRemainder(class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"remainder")));
            }
            return entry;
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item or a potion");
    }

    @Unique
    private static IngredientEntryCondition loadIngredientEntryCondition(JsonObject jsonObject) {
        if (jsonObject.has("data")) {
            if (class_3518.method_15289((JsonObject)jsonObject, (String)"data")) {
                try {
                    class_2487 compoundTag = new class_2522(new StringReader(jsonObject.get("data").getAsString())).method_10727();
                    return new IngredientEntryCondition(compoundTag, NbtUtil.EMPTY_COMPOUND);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            } else if (jsonObject.get("data").isJsonObject()) {
                return IngredientEntryCondition.fromJson((JsonObject)JsonPreprocessor.process((JsonElement)jsonObject.get("data").getAsJsonObject()));
            }
        }
        return IngredientEntryCondition.EMPTY;
    }

    @Override
    public boolean nbtCrafting3$isAdvanced() {
        return this.advancedEntries != null;
    }

    @Override
    public void nbtCrafting$setAdvancedEntries(Stream<? extends IngredientEntry> entries) {
        this.advancedEntries = (IngredientEntry[])entries.filter(Objects::nonNull).toArray(IngredientEntry[]::new);
    }

    @Override
    public class_1799 nbtCrafting3$getRecipeRemainder(class_1799 stack, ReferenceResolver referenceResolver) {
        if (this.advancedEntries != null) {
            for (IngredientEntry entry : this.advancedEntries) {
                class_1799 remainder;
                if (!entry.matches(stack) || (remainder = entry.getRecipeRemainder(stack, referenceResolver)) == null) continue;
                return remainder;
            }
        }
        return null;
    }
}

