/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nbtcrafting3.mixin.network;

import de.siphalor.nbtcrafting3.NbtCrafting;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class})
public class MixinPlayerManager {
    @Shadow
    @Final
    private MinecraftServer field_14360;
    @Shadow
    @Final
    private List<class_3222> field_14351;

    @Inject(method={"onPlayerConnect"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/packet/s2c/play/CustomPayloadS2CPacket;<init>(Lnet/minecraft/util/Identifier;Lnet/minecraft/network/PacketByteBuf;)V")})
    public void beforeRegistrySync(class_2535 connection, class_3222 player, CallbackInfo ci) {
        NbtCrafting.lastServerPlayerEntity.set(player);
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="RETURN")})
    public void afterRecipeSync(class_2535 connection, class_3222 player, CallbackInfo ci) {
        if (NbtCrafting.hasClientMod(player)) {
            NbtCrafting.logInfo("Syncing advanced recipe data to player " + player.method_5820());
            List<class_2540> packets = NbtCrafting.createAdvancedRecipeSyncPackets(this.field_14360.method_3772());
            for (class_2540 packet : packets) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)NbtCrafting.UPDATE_ADVANCED_RECIPES_PACKET_ID, (class_2540)packet);
            }
        } else {
            NbtCrafting.logInfo("Skipping advanced recipe data synchronization for vanillish player " + player.method_5820());
        }
    }

    @Inject(method={"onDataPacksReloaded"}, at={@At(value="RETURN")})
    public void onDataPacksReloaded(CallbackInfo ci) {
        List nbtcPlayers = this.field_14351.stream().filter(NbtCrafting::hasClientMod).collect(Collectors.toList());
        if (!nbtcPlayers.isEmpty()) {
            NbtCrafting.logInfo("Syncing advanced recipe data to " + nbtcPlayers.size() + " players");
            List<class_2540> packets = NbtCrafting.createAdvancedRecipeSyncPackets(this.field_14360.method_3772());
            for (class_2540 packet : packets) {
                for (class_3222 player : nbtcPlayers) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)NbtCrafting.UPDATE_ADVANCED_RECIPES_PACKET_ID, (class_2540)packet);
                }
            }
        } else {
            NbtCrafting.logInfo("No advanced recipe data needs to be synced!");
        }
    }
}

