package de.siphalor.nmuk.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.siphalor.nmuk.NMUK;
import de.siphalor.nmuk.impl.mixin.ControlsOptionsScreenAccessor;
import de.siphalor.nmuk.impl.mixin.EntryListWidgetAccessor;
import de.siphalor.nmuk.impl.mixin.GameOptionsAccessor;
import de.siphalor.nmuk.impl.mixin.KeyBindingRegistryImplAccessor;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_459;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.ApiStatus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@ApiStatus.Internal
public class NMUKKeyBindingHelper {
	public static final Multimap<class_304, class_304> defaultAlternatives = Multimaps.newSetMultimap(new HashMap<>(), HashSet::new);

	public static void removeKeyBinding(class_304 binding) {
		List<class_304> moddedKeyBindings = KeyBindingRegistryImplAccessor.getModdedKeyBindings();
		{
			//noinspection ConstantConditions
			boolean success = moddedKeyBindings.remove(binding);
			if (!success) {
				NMUK.log(Level.ERROR, "Failed to remove modded keybinding!");
			}
		}
		GameOptionsAccessor options = (GameOptionsAccessor) class_310.method_1551().field_1690;
		class_304[] keysAll = options.getKeysAll();
		int index = ArrayUtils.indexOf(keysAll, binding);
		class_304[] newKeysAll = new class_304[keysAll.length - 1];
		System.arraycopy(keysAll, 0, newKeysAll, 0, index);
		System.arraycopy(keysAll, index + 1, newKeysAll, index, keysAll.length - index - 1);
		options.setKeysAll(newKeysAll);
		class_304.method_1426();
	}

	public static void registerKeyBinding(class_304 binding) {
		KeyBindingHelper.registerKeyBinding(binding);
		GameOptionsAccessor options = (GameOptionsAccessor) class_310.method_1551().field_1690;
		if (options != null) { // Game is during initialization - this is handled by Fapi already
			class_304[] keysAll = options.getKeysAll();
			class_304[] newKeysAll = new class_304[keysAll.length + 1];
			System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
			newKeysAll[keysAll.length] = binding;
			options.setKeysAll(newKeysAll);
		}
		class_304.method_1426();
	}

	public static void registerKeyBindings(class_315 gameOptions, Collection<class_304> bindings) {
		GameOptionsAccessor options = (GameOptionsAccessor) gameOptions;
		class_304[] keysAll = options.getKeysAll();
		class_304[] newKeysAll = new class_304[keysAll.length + bindings.size()];
		System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
		int i = keysAll.length;
		for (class_304 binding : bindings) {
			KeyBindingHelper.registerKeyBinding(binding);
			newKeysAll[i] = binding;
			i++;
		}
		options.setKeysAll(newKeysAll);
		class_304.method_1426();
	}

	public static void resetSingleKeyBinding(class_304 keyBinding) {
		keyBinding.method_1422(keyBinding.method_1429());
	}

	public static class_304 createAlternativeKeyBinding(class_304 base) {
		return createAlternativeKeyBinding(base, -1);
	}

	public static class_304 createAlternativeKeyBinding(class_304 base, int code) {
		return createAlternativeKeyBinding(base, class_3675.class_307.field_1668, code);
	}

	public static class_304 createAlternativeKeyBinding(class_304 base, class_3675.class_307 type, int code) {
		IKeyBinding parent = (IKeyBinding) base;
		class_304 alt = new AlternativeKeyBinding(base, base.method_1431() + "%" + parent.nmuk_getNextChildId(), type, code, base.method_1423());
		parent.nmuk_addAlternative(alt);
		return alt;
	}

	public static List<class_459.class_462> getControlsListWidgetEntries() {
		class_437 screen = class_310.method_1551().field_1755;
		if (screen instanceof ControlsOptionsScreenAccessor) {
			//noinspection unchecked
			return (List<class_459.class_462>)(Object)
					((EntryListWidgetAccessor) ((ControlsOptionsScreenAccessor) screen).getKeyBindingListWidget()).getChildren();
		}
		return null;
	}

	public static class_459.class_462 createKeyBindingEntry(class_459 listWidget, class_304 binding, class_2561 text) {
		try {
			// noinspection JavaReflectionMemberAccess,JavaReflectionMemberAccess
			Constructor<class_459.class_462> constructor = class_459.class_462.class.getDeclaredConstructor(class_459.class, class_304.class, class_2561.class);
			constructor.setAccessible(true);
			return constructor.newInstance(listWidget, binding, text);
		} catch (IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
			e.printStackTrace();
		}
		return null;
	}
}
