package de.siphalor.nmuk.impl.mixin;

import de.siphalor.nmuk.impl.IKeyBinding;
import de.siphalor.nmuk.impl.NMUKKeyBindingHelper;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Mixin(value = class_304.class, priority = 800)
public abstract class MixinKeyBinding implements IKeyBinding {
	@Shadow private boolean pressed;
	@Shadow @Final private String category;
	@Shadow @Final private String translationKey;

	@Unique
	private List<class_304> children = null;
	@Unique
	short nextChildId = 0;
	@Unique
	private class_304 parent = null;

	@Override
	public short nmuk_getNextChildId() {
		return nextChildId++;
	}

	@Override
	public void nmuk_setNextChildId(short nextChildId) {
		this.nextChildId = nextChildId;
	}

	@Override
	public boolean nmuk_isAlternative() {
		return parent != null;
	}

	@Override
	public class_304 nmuk_getParent() {
		return parent;
	}

	@Override
	public void nmuk_setParent(class_304 binding) {
		parent = binding;
	}

	@Override
	public List<class_304> nmuk_getAlternatives() {
		return children;
	}

	@Override
	public int nmuk_getAlternativesCount() {
		if (children == null) {
			return 0;
		} else {
			return children.size();
		}
	}

	@Override
	public void nmuk_removeAlternative(class_304 binding) {
		if (children != null) {
			children.remove(binding);
		}
	}

	@Override
	public void nmuk_addAlternative(class_304 binding) {
		if (children == null) {
			children = new LinkedList<>();
		}
		children.add(binding);
	}

	@Override
	public int nmuk_getIndexInParent() {
		if (parent == null) {
			return 0;
		}
		//noinspection RedundantCast
		return ((IKeyBinding) parent).nmuk_getAlternatives().indexOf((class_304)(Object) this);
	}

	@Inject(
			method = "onKeyPressed",
			at = @At(value = "FIELD", target = "Lnet/minecraft/client/options/KeyBinding;timesPressed:I"),
			cancellable = true,
			locals = LocalCapture.CAPTURE_FAILSOFT
	)
	private static void onKeyPressed(class_3675.class_306 key, CallbackInfo callbackInfo, class_304 binding) {
		class_304 parent = ((IKeyBinding) binding).nmuk_getParent();
		if (parent != null) {
			((KeyBindingAccessor) parent).setTimesPressed(((KeyBindingAccessor) parent).getTimesPressed() + 1);
			callbackInfo.cancel();
		}
	}

	@Inject(
			method = "isPressed",
			at = @At("RETURN"),
			cancellable = true
	)
	public void isPressedInjection(CallbackInfoReturnable<Boolean> cir) {
		if (!pressed && children != null && !children.isEmpty()) {
			for (class_304 child : children) {
				if (child.method_1434()) {
					cir.setReturnValue(true);
				}
			}
		}
	}

	@Inject(
			method = "reset",
			at = @At("RETURN")
	)
	private void resetInjection(CallbackInfo callbackInfo) {
		if (children != null && !children.isEmpty()) {
			for (class_304 child : children) {
				child.method_23481(false);
			}
		}
	}

	@Inject(
			method = "compareTo",
			at = @At("HEAD"),
			cancellable = true
	)
	public void compareToInjection(class_304 other, CallbackInfoReturnable<Integer> cir) {
		if (parent != null) {
			if (other == parent) {
				cir.setReturnValue(1);
			} else if (category.equals(other.method_1423())) {
				class_304 otherParent = ((IKeyBinding) other).nmuk_getParent();
				if (otherParent == parent) {
					cir.setReturnValue(Integer.compare(nmuk_getIndexInParent(), ((IKeyBinding) other).nmuk_getIndexInParent()));
				} else {
					cir.setReturnValue(
							class_1074.method_4662(StringUtils.substringBeforeLast(translationKey, "%"))
									.compareTo(class_1074.method_4662(StringUtils.substringBeforeLast(other.method_1431(), "%")))
					);
				}
			}
		}
	}

	@Inject(
			method = "matchesKey",
			at = @At("HEAD"),
			cancellable = true
	)
	public void matchesKeyInjection(int keyCode, int scanCode, CallbackInfoReturnable<Boolean> cir) {
		if (children != null && !children.isEmpty()) {
			for (class_304 child : children) {
				if (child.method_1417(keyCode, scanCode)) {
					cir.setReturnValue(true);
				}
			}
		}
	}

	@Inject(
			method = "matchesMouse",
			at = @At("HEAD"),
			cancellable = true
	)
	public void matchesMouseInjection(int code, CallbackInfoReturnable<Boolean> cir) {
		if (children != null && !children.isEmpty()) {
			for (class_304 child : children) {
				if (child.method_1433(code)) {
					cir.setReturnValue(true);
				}
			}
		}
	}

	@Inject(
			method = "isDefault",
			at = @At("RETURN"),
			cancellable = true
	)
	public void isDefaultInjection(CallbackInfoReturnable<Boolean> cir) {
		if (parent == null) {
			Collection<class_304> defaults = NMUKKeyBindingHelper.defaultAlternatives.get((class_304) (Object) this);
			if (defaults.isEmpty()) {
				if (children != null && !children.isEmpty()) {
					cir.setReturnValue(false);
				}
			} else {
				if (defaults.size() == children.size()) {
					for (class_304 child : children) {
						if (!defaults.contains(child)) {
							cir.setReturnValue(false);
							return;
						}
						if (!child.method_1427()) {
							cir.setReturnValue(false);
							return;
						}
					}
				} else {
					cir.setReturnValue(false);
				}
			}
		}
	}
}
