/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nmuk.impl.mixin;

import de.siphalor.nmuk.NMUK;
import de.siphalor.nmuk.impl.IKeyBinding;
import de.siphalor.nmuk.impl.NMUKKeyBindingHelper;
import de.siphalor.nmuk.impl.mixin.KeyBindingAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_315.class}, priority=800)
public class MixinGameOptions {
    @Unique
    private File nmukOptionsFile;
    @Unique
    private class_304[] tempKeysAll;
    @Mutable
    @Shadow
    @Final
    public class_304[] field_1839;

    @Inject(method={"write"}, at={@At(value="FIELD", target="Lnet/minecraft/client/options/GameOptions;keysAll:[Lnet/minecraft/client/options/KeyBinding;")})
    public void removeNMUKBindings(CallbackInfo ci) {
        this.tempKeysAll = this.field_1839;
        this.field_1839 = (class_304[])Arrays.stream(this.field_1839).filter(binding -> !((IKeyBinding)binding).nmuk_isAlternative()).toArray(class_304[]::new);
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/sound/SoundCategory;values()[Lnet/minecraft/sound/SoundCategory;")})
    public void resetAllKeys(CallbackInfo ci) {
        this.field_1839 = this.tempKeysAll;
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    public void save(CallbackInfo ci) {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.nmukOptionsFile), StandardCharsets.UTF_8));){
            for (class_304 binding : this.field_1839) {
                if (!((IKeyBinding)binding).nmuk_isAlternative()) continue;
                printWriter.println("key_" + binding.method_1431() + ":" + binding.method_1428());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void load(CallbackInfo ci) {
        if (this.nmukOptionsFile == null) {
            this.nmukOptionsFile = new File(class_310.method_1551().field_1697, "options.nmuk.txt");
        }
        if (!this.nmukOptionsFile.exists()) {
            return;
        }
        Map<String, class_304> keyBindings = KeyBindingAccessor.getKeysById();
        Object2IntOpenHashMap alternativeCountMap = new Object2IntOpenHashMap();
        ConcurrentLinkedQueue<class_304> newAlternatives = new ConcurrentLinkedQueue<class_304>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nmukOptionsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    class_304 alternative;
                    int stringIndex = line.lastIndexOf(58);
                    if (stringIndex <= 0) {
                        NMUK.log(Level.WARN, "Invalid nmuk options line: " + line);
                        continue;
                    }
                    String id = line.substring(0, stringIndex);
                    String keyId = line.substring(stringIndex + 1);
                    if (!id.startsWith("key_")) {
                        NMUK.log(Level.WARN, "Invalid nmuk options entry: " + id);
                        continue;
                    }
                    stringIndex = (id = id.substring(4)).indexOf(37);
                    if (stringIndex <= 0) {
                        NMUK.log(Level.WARN, "Nmuk entry is missing an alternative id");
                        continue;
                    }
                    short altId = Short.parseShort(id.substring(stringIndex + 1));
                    id = id.substring(0, stringIndex);
                    class_3675.class_306 boundKey = class_3675.method_15981((String)keyId);
                    class_304 base = keyBindings.get(id);
                    if (base == null) continue;
                    int index = alternativeCountMap.getOrDefault((Object)base, 0);
                    List<class_304> children = ((IKeyBinding)base).nmuk_getAlternatives();
                    ((IKeyBinding)base).nmuk_setNextChildId(altId);
                    if (children == null) {
                        alternative = NMUKKeyBindingHelper.createAlternativeKeyBinding(base);
                        alternative.method_1422(boundKey);
                        newAlternatives.add(alternative);
                    } else if (index < children.size()) {
                        children.get(index).method_1422(boundKey);
                    } else {
                        alternative = NMUKKeyBindingHelper.createAlternativeKeyBinding(base);
                        alternative.method_1422(boundKey);
                        newAlternatives.add(alternative);
                    }
                    alternativeCountMap.putIfAbsent((Object)base, index + 1);
                }
                catch (Throwable e) {
                    NMUK.log(Level.ERROR, "Encountered an issue whilst loading nmuk options file!");
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        class_304[] class_304Array = this.field_1839;
        int n = class_304Array.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                NMUKKeyBindingHelper.registerKeyBindings((class_315)this, newAlternatives);
                return;
            }
            class_304 binding = class_304Array[n2];
            int newCount = alternativeCountMap.getOrDefault((Object)binding, 0);
            int oldCount = ((IKeyBinding)binding).nmuk_getAlternativesCount();
            if (oldCount > newCount) {
                List<class_304> alternatives = ((IKeyBinding)binding).nmuk_getAlternatives();
                alternatives.subList(newCount, oldCount).clear();
            }
            ++n2;
        }
    }
}

