/*
 * Copyright 2021 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nmuk.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.siphalor.nmuk.NMUK;
import de.siphalor.nmuk.impl.mixin.EntryListWidgetAccessor;
import de.siphalor.nmuk.impl.mixin.GameOptionsAccessor;
import de.siphalor.nmuk.impl.mixin.KeybindsScreenAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_459;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.ApiStatus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

@ApiStatus.Internal
public class NMUKKeyBindingHelper {
	public static final Multimap<class_304, class_304> defaultAlternatives = Multimaps.newSetMultimap(new HashMap<>(), HashSet::new);
	private static final boolean isAmecsLoaded = FabricLoader.getInstance().isModLoaded("amecsapi");

	public static void removeKeyBinding(class_304 binding) {
		GameOptionsAccessor options = (GameOptionsAccessor) class_310.method_1551().field_1690;
		class_304[] keysAll = options.getKeyMappings();
		int index = ArrayUtils.indexOf(keysAll, binding);
		if (index < 0) {
			return;
		}
		class_304[] newKeysAll = new class_304[keysAll.length - 1];
		System.arraycopy(keysAll, 0, newKeysAll, 0, index);
		System.arraycopy(keysAll, index + 1, newKeysAll, index, keysAll.length - index - 1);
		options.setKeyMappings(newKeysAll);
		class_304.field_1657.remove(binding.method_1431());
		class_304.method_1426();
	}

	public static void registerKeyBinding(class_304 binding) {
		GameOptionsAccessor options = (GameOptionsAccessor) class_310.method_1551().field_1690;
		if (options != null) {
			class_304[] keysAll = options.getKeyMappings();
			class_304[] newKeysAll = new class_304[keysAll.length + 1];
			System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
			newKeysAll[keysAll.length] = binding;
			options.setKeyMappings(newKeysAll);
		} else {
			KeyBindingHelper.registerKeyBinding(binding);
		}
		class_304.field_1657.put(binding.method_1431(), binding);
		class_304.method_1426();
	}

	public static void registerKeyBindings(class_315 gameOptions, Collection<class_304> bindings) {
		GameOptionsAccessor options = (GameOptionsAccessor) gameOptions;
		class_304[] keysAll = options.getKeyMappings();
		class_304[] newKeysAll = new class_304[keysAll.length + bindings.size()];
		System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
		int i = keysAll.length;
		for (class_304 binding : bindings) {
			newKeysAll[i] = binding;
			class_304.field_1657.put(binding.method_1431(), binding);
			i++;
		}
		options.setKeyMappings(newKeysAll);
		class_304.method_1426();
	}

	public static void resetSingleKeyBinding(class_304 keyBinding) {
		keyBinding.method_1422(keyBinding.method_1429());
		if (isAmecsLoaded) {
			AmecsProxy.resetKeyModifiers(keyBinding);
		}
	}

	public static class_304 createAlternativeKeyBinding(class_304 base) {
		return createAlternativeKeyBinding(base, class_3675.field_16237.method_1442(), class_3675.field_16237.method_1444());
	}

	public static class_304 createAlternativeKeyBinding(class_304 base, class_3675.class_307 type, int code) {
		IKeyBinding parent = (IKeyBinding) base;
		return createAlternativeKeyBindingWithName(
				base,
				base.method_1431() + "%" + parent.nmuk_claimNextChildId(),
				type,
				code
		);
	}

	public static class_304 createAlternativeKeyBindingWithName(class_304 base, String name, class_3675.class_306 key) {
		return createAlternativeKeyBindingWithName(base, name, key.method_1442(), key.method_1444());
	}

	public static class_304 createAlternativeKeyBindingWithName(
			class_304 base,
			String name,
			class_3675.class_307 type,
			int code
	) {
		IKeyBinding parent = (IKeyBinding) base;
		class_304 alt = new AlternativeKeyBinding(base, name, type, code, base.method_1423());
		parent.nmuk_addAlternative(alt);
		return alt;
	}

	//# if MC_VERSION_NUMBER >= 11800
	//- public static List<KeyBindsList.Entry> getControlsListWidgetEntries() {
	//- 	Screen screen = Minecraft.getInstance().screen;
	//- 	if (screen instanceof KeybindsScreenAccessor) {
	//- 		//noinspection unchecked
	//- 		return (List<KeyBindsList.Entry>) (Object)
	//- 				((EntryListWidgetAccessor) ((KeybindsScreenAccessor) screen).getKeyBindsList()).getChildren();
	//- 	}
	//- 	return new ArrayList<>();
	//- }

	//- public static KeyBindsList.KeyEntry createKeyBindingEntry(KeyBindsList listWidget, KeyMapping binding, Component text) {
	//- 	try {
	//- 		Constructor<KeyBindsList.KeyEntry> constructor = KeyBindsList.KeyEntry.class
	//- 				.getDeclaredConstructor(KeyBindsList.class, KeyMapping.class, Component.class);
	//- 		constructor.setAccessible(true);
	//- 		return constructor.newInstance(listWidget, binding, text);
	//- 	} catch (IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
	//- 		NMUK.log(Level.ERROR, "Failed to create GUI representation of key binding", e);
	//- 	}
	//- 	return null;
	//- }
	//# else
	public static List<class_459.class_461> getControlsListWidgetEntries() {
		class_437 screen = class_310.method_1551().field_1755;
		if (screen instanceof KeybindsScreenAccessor) {
			//noinspection unchecked
			return (List<class_459.class_461>) (Object)
					((EntryListWidgetAccessor) ((KeybindsScreenAccessor) screen).getControlList()).getChildren();
		}
		return new ArrayList<>();
	}

	public static class_459.class_462 createKeyBindingEntry(class_459 listWidget, class_304 binding, class_2561 text) {
		try {
			Constructor<class_459.class_462> constructor = class_459.class_462.class
					.getDeclaredConstructor(class_459.class, class_304.class, class_2561.class);
			constructor.setAccessible(true);
			return constructor.newInstance(listWidget, binding, text);
		} catch (IllegalAccessException | InstantiationException | InvocationTargetException | NoSuchMethodException e) {
			NMUK.log(Level.ERROR, "Failed to create GUI representation of key binding", e);
		}
		return null;
	}
	//# end
}
