/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nmuk.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.siphalor.nmuk.NMUK;
import de.siphalor.nmuk.impl.AlternativeKeyBinding;
import de.siphalor.nmuk.impl.AmecsProxy;
import de.siphalor.nmuk.impl.IKeyBinding;
import de.siphalor.nmuk.impl.mixin.EntryListWidgetAccessor;
import de.siphalor.nmuk.impl.mixin.GameOptionsAccessor;
import de.siphalor.nmuk.impl.mixin.KeybindsScreenAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_459;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NMUKKeyBindingHelper {
    public static final Multimap<class_304, class_304> defaultAlternatives = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    private static final boolean isAmecsLoaded = FabricLoader.getInstance().isModLoaded("amecsapi");

    public static void removeKeyBinding(class_304 binding) {
        GameOptionsAccessor options = (GameOptionsAccessor)class_310.method_1551().field_1690;
        Object[] keysAll = options.getKeyMappings();
        int index = ArrayUtils.indexOf((Object[])keysAll, (Object)binding);
        if (index < 0) {
            return;
        }
        class_304[] newKeysAll = new class_304[keysAll.length - 1];
        System.arraycopy(keysAll, 0, newKeysAll, 0, index);
        System.arraycopy(keysAll, index + 1, newKeysAll, index, keysAll.length - index - 1);
        options.setKeyMappings(newKeysAll);
        class_304.field_1657.remove(binding.method_1431());
        class_304.method_1426();
    }

    public static void registerKeyBinding(class_304 binding) {
        GameOptionsAccessor options = (GameOptionsAccessor)class_310.method_1551().field_1690;
        if (options != null) {
            class_304[] keysAll = options.getKeyMappings();
            class_304[] newKeysAll = new class_304[keysAll.length + 1];
            System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
            newKeysAll[keysAll.length] = binding;
            options.setKeyMappings(newKeysAll);
        } else {
            KeyBindingHelper.registerKeyBinding((class_304)binding);
        }
        class_304.field_1657.put(binding.method_1431(), binding);
        class_304.method_1426();
    }

    public static void registerKeyBindings(class_315 gameOptions, Collection<class_304> bindings) {
        GameOptionsAccessor options = (GameOptionsAccessor)gameOptions;
        class_304[] keysAll = options.getKeyMappings();
        class_304[] newKeysAll = new class_304[keysAll.length + bindings.size()];
        System.arraycopy(keysAll, 0, newKeysAll, 0, keysAll.length);
        int i = keysAll.length;
        Iterator<class_304> iterator = bindings.iterator();
        while (iterator.hasNext()) {
            class_304 binding;
            newKeysAll[i] = binding = iterator.next();
            class_304.field_1657.put(binding.method_1431(), binding);
            ++i;
        }
        options.setKeyMappings(newKeysAll);
        class_304.method_1426();
    }

    public static void resetSingleKeyBinding(class_304 keyBinding) {
        keyBinding.method_1422(keyBinding.method_1429());
        if (isAmecsLoaded) {
            AmecsProxy.resetKeyModifiers(keyBinding);
        }
    }

    public static class_304 createAlternativeKeyBinding(class_304 base) {
        return NMUKKeyBindingHelper.createAlternativeKeyBinding(base, class_3675.field_16237.method_1442(), class_3675.field_16237.method_1444());
    }

    public static class_304 createAlternativeKeyBinding(class_304 base, class_3675.class_307 type, int code) {
        IKeyBinding parent = (IKeyBinding)base;
        return NMUKKeyBindingHelper.createAlternativeKeyBindingWithName(base, base.method_1431() + "%" + parent.nmuk_claimNextChildId(), type, code);
    }

    public static class_304 createAlternativeKeyBindingWithName(class_304 base, String name, class_3675.class_306 key) {
        return NMUKKeyBindingHelper.createAlternativeKeyBindingWithName(base, name, key.method_1442(), key.method_1444());
    }

    public static class_304 createAlternativeKeyBindingWithName(class_304 base, String name, class_3675.class_307 type, int code) {
        IKeyBinding parent = (IKeyBinding)base;
        AlternativeKeyBinding alt = new AlternativeKeyBinding(base, name, type, code, base.method_1423());
        parent.nmuk_addAlternative(alt);
        return alt;
    }

    public static List<class_459.class_461> getControlsListWidgetEntries() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof KeybindsScreenAccessor) {
            return ((EntryListWidgetAccessor)((KeybindsScreenAccessor)screen).getKeyBindsList()).getChildren();
        }
        return new ArrayList<class_459.class_461>();
    }

    public static class_459.class_462 createKeyBindingEntry(class_459 listWidget, class_304 binding, class_2561 text) {
        try {
            Constructor constructor = class_459.class_462.class.getDeclaredConstructor(class_459.class, class_304.class, class_2561.class);
            constructor.setAccessible(true);
            return (class_459.class_462)constructor.newInstance(listWidget, binding, text);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            NMUK.log(Level.ERROR, "Failed to create GUI representation of key binding", e);
            return null;
        }
    }
}

