/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.nmuk.impl.mixin;

import de.siphalor.nmuk.NMUK;
import de.siphalor.nmuk.impl.IKeyBinding;
import de.siphalor.nmuk.impl.NMUKKeyBindingHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_315.class}, priority=800)
public class MixinGameOptions {
    @Unique
    private File nmukOptionsFile;
    @Unique
    private class_304[] tempKeysAll;
    @Mutable
    @Shadow
    @Final
    public class_304[] field_1839;

    @Inject(method={"processOptions"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Options;keyMappings:[Lnet/minecraft/client/KeyMapping;")})
    public void removeNMUKBindings(CallbackInfo ci) {
        this.tempKeysAll = this.field_1839;
        this.field_1839 = (class_304[])Arrays.stream(this.field_1839).filter(binding -> !((IKeyBinding)binding).nmuk_isAlternative()).toArray(class_304[]::new);
    }

    @Inject(method={"processOptions"}, at={@At(value="INVOKE", target="Lnet/minecraft/sounds/SoundSource;values()[Lnet/minecraft/sounds/SoundSource;")})
    public void resetAllKeys(CallbackInfo ci) {
        this.field_1839 = this.tempKeysAll;
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void save(CallbackInfo ci) {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.nmukOptionsFile), StandardCharsets.UTF_8));){
            for (class_304 binding : this.field_1839) {
                if (!((IKeyBinding)binding).nmuk_isAlternative()) continue;
                printWriter.println("key_" + binding.method_1431() + ":" + binding.method_1428());
            }
        }
        catch (FileNotFoundException e) {
            NMUK.log(Level.ERROR, "Failed to save NMUK key binding alternatives", e);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void load(CallbackInfo ci) {
        if (this.nmukOptionsFile == null) {
            this.nmukOptionsFile = new File(class_310.method_1551().field_1697, "options.nmuk.txt");
        }
        if (!this.nmukOptionsFile.exists()) {
            return;
        }
        Map keyBindings = class_304.field_1657;
        HashSet<String> encounteredKeyBindingNames = new HashSet<String>(this.field_1839.length * 2);
        ArrayList<class_304> newAlternatives = new ArrayList<class_304>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nmukOptionsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    int stringIndex = line.lastIndexOf(58);
                    if (stringIndex <= 0) {
                        NMUK.log(Level.WARN, "Invalid nmuk options line: " + line);
                        continue;
                    }
                    String name = line.substring(0, stringIndex);
                    String keyId = line.substring(stringIndex + 1);
                    if (!name.startsWith("key_")) {
                        NMUK.log(Level.WARN, "Invalid nmuk options entry: " + name);
                        continue;
                    }
                    stringIndex = (name = name.substring(4)).indexOf(37);
                    if (stringIndex <= 0) {
                        NMUK.log(Level.WARN, "Nmuk entry is missing an alternative id");
                        continue;
                    }
                    short altId = Short.parseShort(name.substring(stringIndex + 1));
                    String baseName = name.substring(0, stringIndex);
                    class_3675.class_306 boundKey = class_3675.method_15981((String)keyId);
                    class_304 baseBinding = (class_304)keyBindings.get(baseName);
                    if (baseBinding == null) {
                        NMUK.log(Level.WARN, "Key binding " + baseName + " doesn't exist");
                        continue;
                    }
                    IKeyBinding baseBindingAccessor = (IKeyBinding)baseBinding;
                    baseBindingAccessor.nmuk_setNextChildId((short)Math.max(altId, baseBindingAccessor.nmuk_getNextChildId()));
                    class_304 altBinding = (class_304)keyBindings.get(name);
                    if (altBinding == null) {
                        altBinding = NMUKKeyBindingHelper.createAlternativeKeyBindingWithName(baseBinding, name, boundKey);
                        newAlternatives.add(altBinding);
                    }
                    altBinding.method_1422(boundKey);
                    encounteredKeyBindingNames.add(name);
                }
                catch (Throwable e) {
                    NMUK.log(Level.WARN, "Encountered an issue whilst loading nmuk options file!", e);
                }
            }
        }
        catch (IOException e) {
            NMUK.log(Level.ERROR, "Failed to load nmuk options file");
        }
        TreeSet<class_304> newAllKeyMappings = new TreeSet<class_304>(Arrays.asList(this.field_1839));
        newAllKeyMappings.addAll(newAlternatives);
        for (class_304 keyMapping : this.field_1839) {
            class_304 parent;
            if (encounteredKeyBindingNames.contains(keyMapping.method_1431()) || (parent = ((IKeyBinding)keyMapping).nmuk_getParent()) == null) continue;
            List<class_304> alternatives = ((IKeyBinding)parent).nmuk_getAlternatives();
            alternatives.remove(keyMapping);
            newAllKeyMappings.remove(keyMapping);
            class_304.field_1657.remove(keyMapping.method_1431());
        }
        this.field_1839 = newAllKeyMappings.toArray(new class_304[0]);
        class_304.method_1426();
    }
}

