/*
 * Copyright 2021 Siphalor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

package de.siphalor.nmuk.impl;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.jetbrains.annotations.ApiStatus;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

@ApiStatus.Internal
public class AlternativeKeyBinding extends class_304 {
	public AlternativeKeyBinding(
			class_304 parent,
			String translationKey,
			int code,
			//# if MC_VERSION_NUMBER >= 12109
			class_11900 category
			//# else
			//- String category
			//# end
	) {
		super(translationKey, code, category);
		((IKeyBinding) this).nmuk_setParent(parent);
	}

	public AlternativeKeyBinding(
			class_304 parent,
			String translationKey,
			class_3675.class_307 type,
			int code,
			//# if MC_VERSION_NUMBER >= 12109
			class_11900 category
			//# else
			//- String category
			//# end
	) {
		super(translationKey, type, code, category);
		((IKeyBinding) this).nmuk_setParent(parent);
	}

	@Override
	public boolean method_1427() {
		if (method_1429() == class_3675.field_16237) {
			return true;
		}
		return super.method_1427();
	}

	private static final MethodHandle INCREMENT_TIMES_PRESSED_SUPER;
	static {
		MethodHandle methodHandle;
		try {
			methodHandle = MethodHandles.lookup().unreflectSpecial(class_304.class.getDeclaredMethod("amecs$incrementTimesPressed"), AlternativeKeyBinding.class);
		} catch (NoSuchMethodException | IllegalAccessException e) {
			if (FabricLoader.getInstance().isModLoaded("amecsapi")) {
				throw new RuntimeException("Failed to initialize NMUK compatibility with Amecs", e);
			}
			methodHandle = null;
		}
		INCREMENT_TIMES_PRESSED_SUPER = methodHandle;
	}
	public void amecs$incrementTimesPressed() throws Throwable {
		INCREMENT_TIMES_PRESSED_SUPER.invoke(this);

		class_304 parent = ((IKeyBinding) this).nmuk_getParent();
		((de.siphalor.amecs.impl.duck.IKeyBinding) parent).amecs$incrementTimesPressed();
	}
}
