/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.pushtocraft.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.pushtocraft.PushToCraftManager;
import de.siphalor.pushtocraft.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1856;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_1856.class}, priority=2000)
public class MixinIngredient {
    @Unique
    private static final String PROCESSED_ENTRY_TAG = "pushtocraft:processed";

    @ModifyVariable(method={"fromJson"}, at=@At(value="HEAD"), argsOnly=true)
    private static JsonElement onFromJson(JsonElement jsonElement) {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            if (object.has("type")) {
                return object;
            }
            if (object.has(PROCESSED_ENTRY_TAG)) {
                return object;
            }
            object.addProperty(PROCESSED_ENTRY_TAG, Boolean.valueOf(true));
            String id2 = MixinIngredient.extractId(object);
            JsonArray jsonArray = MixinIngredient.processEntries(Collections.singleton(id2), null, s -> {
                JsonObject copy = Util.shallowCopy(object);
                copy.remove("tag");
                copy.remove("item");
                return copy;
            });
            if (jsonArray.size() == 0) {
                return object;
            }
            jsonArray.add((JsonElement)object);
            return jsonArray;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            HashMap<String, JsonObject> ids = new HashMap<String, JsonObject>();
            for (JsonElement ele : jsonArray) {
                JsonObject object;
                if (!ele.isJsonObject() || (object = ele.getAsJsonObject()).has("type") || object.has(PROCESSED_ENTRY_TAG)) continue;
                ids.put(MixinIngredient.extractId(object), object);
            }
            if (ids.isEmpty()) {
                return jsonArray;
            }
            return MixinIngredient.processEntries(ids.keySet(), jsonArray, id -> {
                JsonObject copy = Util.shallowCopy((JsonObject)ids.get(id));
                copy.remove("item");
                copy.remove("tag");
                copy.addProperty(PROCESSED_ENTRY_TAG, Boolean.valueOf(true));
                return copy;
            });
        }
        return jsonElement;
    }

    @Unique
    private static String extractId(JsonObject obj) {
        if (obj.has("item")) {
            return class_3518.method_15253((JsonObject)obj, (String)"item", (String)"");
        }
        return "#" + class_3518.method_15253((JsonObject)obj, (String)"tag", (String)"");
    }

    @Unique
    private static JsonArray processEntries(Set<String> ingredientEntries, JsonArray jsonArray, Function<String, JsonObject> jsonObjectSupplier) {
        if (jsonArray == null) {
            jsonArray = new JsonArray();
        }
        JsonArray finalArray = jsonArray;
        PushToCraftManager.getInstance().getMatches(Util.currentRecipeId, Util.currentRecipeSerializer).forEach(entry -> {
            for (String id : entry.getTargets()) {
                if (!ingredientEntries.contains(id)) continue;
                for (String addition : entry.getAdditions()) {
                    JsonObject obj = (JsonObject)jsonObjectSupplier.apply(id);
                    if (addition.charAt(0) == '#') {
                        obj.addProperty("tag", addition.substring(1));
                    } else {
                        obj.addProperty("item", addition);
                    }
                    finalArray.add((JsonElement)obj);
                }
            }
        });
        return finalArray;
    }
}

