/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.pushtocraft;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.pushtocraft.PushToCraft;
import de.siphalor.pushtocraft.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class PushToCraftManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, Collection<Entry>> exactPushes = new HashMap<String, Collection<Entry>>();
    private final Map<String, Collection<class_3545<Pattern, Entry>>> namespacePushes = new HashMap<String, Collection<class_3545<Pattern, Entry>>>();
    private final Collection<class_3545<Pattern, Entry>> flexiblePushes = new LinkedList<class_3545<Pattern, Entry>>();
    private final Collection<Entry> wildcardPushes = new LinkedList<Entry>();
    private static PushToCraftManager instance;

    public static PushToCraftManager getInstance() {
        return instance;
    }

    public PushToCraftManager() {
        super(GSON, "push_to_craft");
        instance = this;
    }

    public String method_22322() {
        return "pushtocraft";
    }

    protected void apply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        this.exactPushes.clear();
        this.namespacePushes.clear();
        this.flexiblePushes.clear();
        this.wildcardPushes.clear();
        for (Map.Entry<class_2960, JsonElement> e : resources.entrySet()) {
            class_2960 identifier = e.getKey();
            if (!e.getValue().isJsonObject()) {
                this.logError(identifier, "must be a JSON Object");
                continue;
            }
            JsonObject jsonObject = e.getValue().getAsJsonObject();
            if (jsonObject.has("additions")) {
                JsonElement element = jsonObject.get("additions");
                if (element.isJsonArray()) {
                    LinkedList<String> additions = new LinkedList<String>();
                    for (Object additionElement : element.getAsJsonArray()) {
                        if (Util.isString((JsonElement)additionElement)) {
                            additions.add(additionElement.getAsString());
                            continue;
                        }
                        this.logWarn(identifier, "contains an illegal additions entry of type " + additionElement.getClass().getSimpleName());
                    }
                    Collection<Object> targets = null;
                    if (jsonObject.has("targets")) {
                        element = jsonObject.get("targets");
                        if (element.isJsonArray()) {
                            Object additionElement;
                            targets = new LinkedList();
                            additionElement = element.getAsJsonArray().iterator();
                            while (additionElement.hasNext()) {
                                JsonElement targetElement = (JsonElement)additionElement.next();
                                if (Util.isString(targetElement)) {
                                    targets.add(targetElement.getAsString());
                                    continue;
                                }
                                this.logWarn(identifier, "has item/tag target in array of invalid type " + targetElement.getClass().getSimpleName() + " - should be string");
                            }
                        } else if (Util.isString(element)) {
                            targets = Collections.singleton(element.getAsString());
                        } else {
                            this.logError(identifier, "has item/tag target of invalid type " + element.getClass().getSimpleName() + " - should be string or array of strings");
                        }
                    }
                    if (targets == null || targets.isEmpty()) {
                        this.logError(identifier, "targets no items or tags");
                        continue;
                    }
                    if (jsonObject.has("recipes")) {
                        element = jsonObject.get("recipes");
                        if (element.isJsonObject()) {
                            jsonObject = element.getAsJsonObject();
                            List<class_1865<?>> recipeSerializers = Collections.emptyList();
                            if (jsonObject.has("types")) {
                                element = jsonObject.get("types");
                                if (element.isJsonArray()) {
                                    recipeSerializers = new LinkedList();
                                    for (JsonElement recipeSerializerElement : element.getAsJsonArray()) {
                                        if (Util.isString(recipeSerializerElement)) {
                                            class_2960 recipeSerializerId = new class_2960(recipeSerializerElement.getAsString());
                                            if (class_2378.field_17598.method_10250(recipeSerializerId)) {
                                                recipeSerializers.add((class_1865)class_2378.field_17598.method_10223(recipeSerializerId));
                                                continue;
                                            }
                                            this.logWarn(identifier, "has recipe type specifier \"" + recipeSerializerId + "\" that could not be resolved to a recipe type");
                                            continue;
                                        }
                                        this.logWarn(identifier, "has recipe type specifier in array of invalid type " + recipeSerializerElement.getClass().getSimpleName() + " - should be a string");
                                    }
                                    if (recipeSerializers.isEmpty()) {
                                        this.logError(identifier, "has empty or completely invalid recipe type specifier array");
                                        continue;
                                    }
                                } else {
                                    this.logError(identifier, "has recipe type specifier of invalid type " + element.getClass().getSimpleName() + " - should be an array");
                                    continue;
                                }
                            }
                            Entry entry = new Entry(targets, additions, recipeSerializers);
                            if (jsonObject.has("ids")) {
                                element = jsonObject.get("ids");
                                if (element.isJsonArray()) {
                                    boolean valid = false;
                                    for (JsonElement idElement : element.getAsJsonArray()) {
                                        if (Util.isString(idElement)) {
                                            String id = idElement.getAsString();
                                            if (id.charAt(0) == '/' && id.endsWith("/")) {
                                                this.flexiblePushes.add((class_3545<Pattern, Entry>)new class_3545((Object)Pattern.compile(id.substring(1, id.length() - 1)), (Object)entry));
                                            } else {
                                                String path;
                                                String namespace;
                                                int index = id.indexOf(58);
                                                if (index == -1) {
                                                    namespace = "minecraft";
                                                    path = id;
                                                } else {
                                                    namespace = id.substring(0, index);
                                                    path = id.substring(index + 1);
                                                }
                                                if (path.charAt(0) == '/' && path.endsWith("/")) {
                                                    this.namespacePushes.computeIfAbsent(namespace, s -> new LinkedList()).add(new class_3545((Object)Pattern.compile(path.substring(1, path.length() - 1)), (Object)entry));
                                                } else {
                                                    this.exactPushes.computeIfAbsent(path, s -> new LinkedList()).add(entry);
                                                }
                                            }
                                            valid = true;
                                            continue;
                                        }
                                        this.logWarn(identifier, "has recipe id in array of invalid type " + idElement.getClass().getSimpleName() + " - should be a string");
                                    }
                                    if (valid) continue;
                                    this.logError(identifier, "has no valid recipes ids in array");
                                    continue;
                                }
                                this.logError(identifier, "has recipe ids tag of invalid type " + element.getClass().getSimpleName() + " - should be an array");
                                continue;
                            }
                            this.wildcardPushes.add(entry);
                            continue;
                        }
                        this.logError(identifier, "has recipes specifier of invalid type " + element.getClass().getSimpleName() + " - should be an object");
                        continue;
                    }
                    this.logError(identifier, "targets no recipes");
                    continue;
                }
                this.logError(identifier, "has an ill-formed additions tag of type " + element.getClass().getSimpleName());
                continue;
            }
            this.logError(identifier, "is missing additions list. Sorry but pushing nothing makes no sense O_O");
        }
    }

    private void logError(class_2960 identifier, String errorText) {
        PushToCraft.LOGGER.error("PushToCraft entry " + identifier + " " + errorText);
    }

    private void logWarn(class_2960 identifier, String warnText) {
        PushToCraft.LOGGER.warn("PushToCraft entry " + identifier + " " + warnText);
    }

    public Stream<Entry> getMatches(class_2960 recipeId, class_1865<?> recipeSerializer) {
        String recipeIdString = recipeId.toString();
        String path = recipeId.method_12832();
        return Streams.concat((Stream[])new Stream[]{((Collection)this.exactPushes.getOrDefault(recipeIdString, Collections.emptyList())).parallelStream(), ((Collection)this.namespacePushes.getOrDefault(recipeId.method_12836(), Collections.emptyList())).parallelStream().filter(pair -> ((Pattern)pair.method_15442()).matcher(path).matches()).map(class_3545::method_15441), this.flexiblePushes.parallelStream().filter(pair -> ((Pattern)pair.method_15442()).matcher(recipeIdString).matches()).map(class_3545::method_15441), this.wildcardPushes.parallelStream()}).filter(entry -> entry.recipeSerializerMatches(recipeSerializer));
    }

    public static class Entry {
        private final Collection<String> targets;
        private final Collection<String> additions;
        private final Collection<class_1865<?>> recipeSerializers;

        public Entry(Collection<String> targets, Collection<String> additions, Collection<class_1865<?>> recipeSerializers) {
            this.targets = targets;
            this.additions = additions;
            this.recipeSerializers = recipeSerializers;
        }

        public boolean recipeSerializerMatches(class_1865<?> recipeSerializer) {
            if (this.recipeSerializers.isEmpty()) {
                return true;
            }
            return this.recipeSerializers.contains(recipeSerializer);
        }

        public Collection<String> getAdditions() {
            return this.additions;
        }

        public Collection<String> getTargets() {
            return this.targets;
        }
    }
}

