/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.pushtocraft.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.siphalor.pushtocraft.PushToCraftManager;
import de.siphalor.pushtocraft.Util;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1856;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_1856.class}, priority=2000)
public class MixinIngredient {
    @Shadow
    private IntList field_9016;

    @ModifyVariable(method={"fromJson"}, at=@At(value="HEAD"), argsOnly=true)
    private static JsonElement onFromJson(JsonElement jsonElement) {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement.isJsonObject()) {
            String id2 = MixinIngredient.extractId(jsonElement.getAsJsonObject());
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(jsonElement);
            JsonObject baseClone = Util.shallowCopy(jsonElement.getAsJsonObject());
            baseClone.remove("tag");
            baseClone.remove("item");
            MixinIngredient.processEntries(Collections.singleton(id2), jsonArray, s -> Util.shallowCopy(baseClone));
            return jsonArray;
        }
        if (jsonElement.isJsonArray()) {
            HashMap<String, JsonObject> ids = new HashMap<String, JsonObject>();
            for (JsonElement ele : jsonElement.getAsJsonArray()) {
                if (!ele.isJsonObject()) continue;
                JsonObject object = ele.getAsJsonObject();
                ids.put(MixinIngredient.extractId(object), object);
            }
            MixinIngredient.processEntries(ids.keySet(), jsonElement.getAsJsonArray(), id -> {
                JsonObject copy = Util.shallowCopy((JsonObject)ids.get(id));
                copy.remove("item");
                copy.remove("tag");
                return copy;
            });
            return jsonElement;
        }
        return jsonElement;
    }

    @Unique
    private static String extractId(JsonObject obj) {
        if (obj.has("item")) {
            return class_3518.method_15253((JsonObject)obj, (String)"item", (String)"");
        }
        return class_3518.method_15253((JsonObject)obj, (String)"tag", (String)"");
    }

    @Unique
    private static void processEntries(Set<String> ingredientEntries, JsonArray jsonArray, Function<String, JsonObject> jsonObjectSupplier) {
        PushToCraftManager.getInstance().getMatches(Util.currentRecipeId, Util.currentRecipeSerializer).forEach(entry -> {
            for (String id : entry.getTargets()) {
                if (!ingredientEntries.contains(id)) continue;
                for (String addition : entry.getAdditions()) {
                    JsonObject obj = (JsonObject)jsonObjectSupplier.apply(id);
                    if (addition.charAt(0) == '#') {
                        obj.addProperty("tag", addition.substring(1));
                    } else {
                        obj.addProperty("item", addition);
                    }
                    jsonArray.add((JsonElement)obj);
                }
            }
        });
    }
}

