package de.siphalor.spiceoffabric;

import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.server.Commands;
import de.siphalor.spiceoffabric.util.IHungerManager;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2749;
import net.minecraft.class_2781;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.UUID;

public class SpiceOfFabric implements ModInitializer {

	public static final String MOD_ID = "spiceoffabric";
	public static final String NBT_FOOD_HISTORY_ID = "spiceOfFabric_history";
	public static final String NBT_VERSION_ID = "spiceOfFabric_version";
	public static final int NBT_VERSION = 1;
	public static final String FOOD_JOURNAL_FLAG = MOD_ID + ":food_journal";
	public static final class_2960 SYNC_FOOD_HISTORY_S2C_PACKET = new class_2960(MOD_ID, "sync_food_history");
	public static final class_2960 ADD_FOOD_S2C_PACKET = new class_2960(MOD_ID, "add_food");
	public static final class_2960 CLEAR_FOODS_S2C_PACKET = new class_2960(MOD_ID, "clear_foods");

	public static final UUID PLAYER_HEALTH_MODIFIER_UUID = UUID.nameUUIDFromBytes(MOD_ID.getBytes(StandardCharsets.UTF_8));

	@Override
	public void onInitialize() {
		ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
			syncFoodHistory(handler.field_14140);
		});

		Commands.register();
	}

	public static boolean hasMod(class_3222 player) {
		return ServerPlayNetworking.canSend(player, SYNC_FOOD_HISTORY_S2C_PACKET);
	}

	public static void onEaten(class_3222 player, FoodHistory foodHistory, class_1799 stack) {
		foodHistory.addFood(stack, player);
		player.field_13987.method_14364(new class_2749(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
		if (Config.carrot.enable && (player.method_6063() < Config.carrot.maxHealth || Config.carrot.maxHealth == -1)) {
			SpiceOfFabric.updateMaxHealth(player, true, true);
		}
	}

	public static class_1322 createHealthModifier(double amount) {
		return new class_1322(
				PLAYER_HEALTH_MODIFIER_UUID,
				MOD_ID,
				amount,
				class_1322.class_1323.field_6328
		);
	}

	public static void updateMaxHealth(class_3222 player, boolean sync, boolean announce) {
		class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
		double oldValue = maxHealthAttr.method_6194();
		maxHealthAttr.method_6200(PLAYER_HEALTH_MODIFIER_UUID);
		FoodHistory foodHistory = ((IHungerManager) player.method_7344()).spiceOfFabric_getFoodHistory();
		maxHealthAttr.method_26837(createHealthModifier(foodHistory.getCarrotHealthOffset(player)));
		if (sync) {
			player.field_13987.method_14364(new class_2781(player.method_5628(), Collections.singleton(maxHealthAttr)));
			player.field_13987.method_14364(new class_2749(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
		}
		if (announce && maxHealthAttr.method_6194() > oldValue) {
			player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 1F, 1F);
		}
	}

	public static void syncFoodHistory(class_3222 serverPlayerEntity) {
		if (ServerPlayNetworking.canSend(serverPlayerEntity, SYNC_FOOD_HISTORY_S2C_PACKET)) {
			class_2540 buffer = new class_2540(Unpooled.buffer());
			((IHungerManager) serverPlayerEntity.method_7344()).spiceOfFabric_getFoodHistory().write(buffer);
			ServerPlayNetworking.send(serverPlayerEntity, SYNC_FOOD_HISTORY_S2C_PACKET, buffer);
		}
	}
}
