package de.siphalor.spiceoffabric.client;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.util.IHungerManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.food.FoodValues;

public class ClientCore implements ClientModInitializer {
	private static class_2540 lastSyncPacket;

	@Override
	public void onInitializeClient() {
		ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
			if (lastSyncPacket != null) {
				((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_getFoodHistory().read(lastSyncPacket);
				lastSyncPacket.release();
				lastSyncPacket = null;
			}
		});
		ClientPlayNetworking.registerGlobalReceiver(SpiceOfFabric.SYNC_FOOD_HISTORY_S2C_PACKET, (client, handler, buf, responseSender) -> {
			if (client.field_1724 != null && client.field_1724.method_7344() != null) {
				((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_getFoodHistory().read(buf);
			} else {
				lastSyncPacket = new class_2540(buf.copy());
				lastSyncPacket.retain();
			}
		});
		ClientPlayNetworking.registerGlobalReceiver(SpiceOfFabric.ADD_FOOD_S2C_PACKET, (client, handler, buf, responseSender) ->
				((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_getFoodHistory().addFood(FoodHistoryEntry.from(buf))
		);
		ClientPlayNetworking.registerGlobalReceiver(SpiceOfFabric.CLEAR_FOODS_S2C_PACKET, (client, handler, buf, responseSender) ->
				((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_clearHistory()
		);
	}
}
