package de.siphalor.spiceoffabric.foodhistory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.nbt.*;
import net.minecraft.text.*;
import java.util.*;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FoodHistory {

	public Set<FoodHistoryEntry> carrotHistory;

	public BiMap<Integer, FoodHistoryEntry> dictionary;
	public int nextId = 0;
	public Queue<Integer> history;
	public Map<Integer, Integer> stats;

	public FoodHistory() {
		setup();
	}

	public void setup() {
		dictionary = HashBiMap.create();
		history = new ConcurrentLinkedQueue<>();
		stats = new Int2IntArrayMap();
		carrotHistory = new HashSet<>();
	}

	public void reset() {
		resetHistory();
		resetCarrotHistory();
	}

	public void resetHistory() {
		dictionary.clear();
		nextId = 0;
		history.clear();
		stats.clear();
	}

	public void resetCarrotHistory() {
		carrotHistory.clear();
	}

	public void write(class_2540 buffer) {
		buffer.method_10804(dictionary.size());
		for (Map.Entry<Integer, FoodHistoryEntry> entry : dictionary.entrySet()) {
			buffer.method_10804(entry.getKey());
			entry.getValue().write(buffer);
		}
		buffer.method_10804(history.size());
		for (int integer : history) {
			buffer.method_10804(integer);
		}
		if (Config.carrot.enable) {
			buffer.writeBoolean(true);
			buffer.method_10804(carrotHistory.size());
			for (FoodHistoryEntry entry : carrotHistory) {
				entry.write(buffer);
			}
		} else {
			buffer.writeBoolean(false);
		}
	}

	public void read(class_2540 buffer) {
		for (int l = buffer.method_10816(), i = 0; i < l; i++) {
			dictionary.put(buffer.method_10816(), FoodHistoryEntry.from(buffer));
		}
		for (int l = buffer.method_10816(), i = 0; i < l; i++) {
			history.offer(buffer.method_10816());
		}
		if (buffer.readBoolean()) {
			final int length = buffer.method_10816();
			carrotHistory = new HashSet<>(length);
			for (int i = 0; i < length; i++) {
				carrotHistory.add(FoodHistoryEntry.from(buffer));
			}
		}
		buildStats();
	}

	public class_2487 write(class_2487 compoundTag) {
		defragmentDictionary();
		class_2499 list = new class_2499();
		for (Map.Entry<Integer, FoodHistoryEntry> entry : dictionary.entrySet()) {
			list.method_10531(entry.getKey(), entry.getValue().write(new class_2487()));
		}
		compoundTag.method_10566("dictionary", list);
		class_2499 historyList = new class_2499();
		for (Integer id : history) {
			historyList.add(class_2497.method_23247(id));
		}
		compoundTag.method_10566("history", historyList);
		class_2499 carrotHistoryList = new class_2499();
		for (FoodHistoryEntry entry : carrotHistory) {
			carrotHistoryList.add(entry.write(new class_2487()));
		}
		compoundTag.method_10566("carrotHistory", carrotHistoryList);
		return compoundTag;
	}

	public static FoodHistory read(class_2487 compoundTag) {
		FoodHistory foodHistory = new FoodHistory();
		class_2499 list = (class_2499) compoundTag.method_10580("dictionary");
		for (int i = 0; i < list.size(); i++) {
			FoodHistoryEntry entry = new FoodHistoryEntry().read(list.method_10602(i));
			if (entry != null) {
				foodHistory.dictionary.put(i, entry);
			}
		}
		foodHistory.nextId = foodHistory.dictionary.size();
		list = (class_2499) compoundTag.method_10580("history");
		for (class_2520 tag : list) {
			foodHistory.history.offer(((class_2497) tag).method_10701());
		}
		foodHistory.buildStats();

		if (compoundTag.method_10545("carrotHistory")) {
			list = (class_2499) compoundTag.method_10580("carrotHistory");
			if (Config.carrot.enable) {
				foodHistory.carrotHistory = new HashSet<>(list.size());
				for (class_2520 tag : list) {
					foodHistory.carrotHistory.add(new FoodHistoryEntry().read((class_2487) tag));
				}
			}
		}
		return foodHistory;
	}

	public void buildStats() {
		stats.clear();
		for (Integer id : history) {
			if (stats.containsKey(id)) {
				stats.put(id, stats.get(id) + 1);
			} else {
				stats.put(id, 1);
			}
		}
	}

	public void defragmentDictionary() {
		Map<Integer, Integer> oldToNewMap = new HashMap<>();
		int i = 0;
		for (Integer id : dictionary.keySet()) {
			oldToNewMap.put(id, i);
			i++;
		}
		nextId = i;
		Queue<Integer> newHistory = new ConcurrentLinkedQueue<>();
		while (true) {
			Integer id = history.poll();
			if (id == null) break;
			newHistory.offer(id);
		}
		history = newHistory;
		Map<Integer, Integer> newStats = new Int2IntArrayMap();
		for (Map.Entry<Integer, Integer> entry : stats.entrySet()) {
			newStats.put(oldToNewMap.get(entry.getKey()), entry.getValue());
		}
		stats = newStats;
		BiMap<Integer, FoodHistoryEntry> newDictionary = HashBiMap.create();
		for (Map.Entry<Integer, FoodHistoryEntry> entry : dictionary.entrySet()) {
			newDictionary.put(oldToNewMap.get(entry.getKey()), entry.getValue());
		}
		dictionary = newDictionary;
	}

	public int getTimesEaten(class_1799 stack) {
		return stats.getOrDefault(dictionary.inverse().get(FoodHistoryEntry.fromItemStack(stack)), 0);
	}

	public void addFood(class_1799 stack, class_3222 serverPlayerEntity) {
		FoodHistoryEntry entry = FoodHistoryEntry.fromItemStack(stack);

		if (ServerPlayNetworking.canSend(serverPlayerEntity, SpiceOfFabric.ADD_FOOD_S2C_PACKET)) {
			class_2540 buffer = new class_2540(Unpooled.buffer());
			entry.write(buffer);
			ServerPlayNetworking.send(serverPlayerEntity, SpiceOfFabric.ADD_FOOD_S2C_PACKET, buffer);
		}
		addFood(entry);
	}

	public void addFood(FoodHistoryEntry entry) {
		Integer id = dictionary.inverse().get(entry);
		if (id == null) {
			id = nextId++;
			dictionary.put(id, entry);
		}
		history.offer(id);
		while (history.size() > Config.food.historyLength) {
			removeLastFood();
		}
		stats.put(id, stats.getOrDefault(id, 0) + 1);

		if (Config.carrot.enable) {
			carrotHistory.add(entry);
		}
	}

	public void removeLastFood() {
		int id = history.remove();
		if (stats.containsKey(id)) stats.put(id, stats.get(id) - 1);
	}

	public int getCarrotHealthOffset(class_1657 player) {
		class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
		Config.setHealthFormulaExpressionValues(carrotHistory.size(), (int) maxHealthAttr.method_6201());
		return Math.max(1, class_3532.method_15357(Config.healthFormulaExpression.evaluate())) - (int) maxHealthAttr.method_6201();
	}

	public int getCarrotMaxHealth(class_1657 player) {
		class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
		Config.setHealthFormulaExpressionValues(carrotHistory.size(), (int) maxHealthAttr.method_6201());
		return class_3532.method_15357(Config.healthFormulaExpression.evaluate());
	}

	public class_2499 genJournalPages(class_1657 playerEntity) {
		boolean hasMod = ServerPlayNetworking.canSend((class_3222) playerEntity, SpiceOfFabric.ADD_FOOD_S2C_PACKET);

		class_2499 pages = new class_2499();

		class_2585 textOnPage = new class_2585("");
		textOnPage.method_10852(
				hasMod
						? new class_2588(SpiceOfFabric.MOD_ID + ".journal.inside_title")
						: new class_2585("\u25b6 Diet Journal \u25c0")
						.method_10862(class_2583.field_24360
								.method_10977(class_124.field_1063)
								.method_27706(class_124.field_1073)
								.method_10982(true)
						)
		);
		textOnPage.method_27693("\n\n");

		class_2583 numberStyle = class_2583.field_24360.method_10982(true);
		class_2583 itemStyle = class_2583.field_24360.method_10977(class_124.field_1063);

		int linesOnPage = 2;
		int number = 1;
		for (int foodId : history) {
			FoodHistoryEntry entry = dictionary.get(foodId);
			if (hasMod) {
				textOnPage.method_10852(
						new class_2588(
								SpiceOfFabric.MOD_ID + ".journal.line",
								number,
								entry.getStackName()
						).method_10862(
								class_2583.field_24360.
										method_10949(new class_2568(class_2568.class_5247.field_24343,
												new class_2568.class_5249(entry.getStack())))))
						.method_27693("\n");
			} else {
				textOnPage.method_10852(new class_2585(number + ". ").method_10862(numberStyle))
						.method_10852(entry.getStackName().method_10862(
								itemStyle.method_10949(
										new class_2568(
												class_2568.class_5247.field_24343,
												new class_2568.class_5249(entry.getStack())
										)
								).method_10982(false))
						).method_27693("\n");
			}
			number++;
			linesOnPage++;
			if (linesOnPage >= 14) {
				pages.add(class_2519.method_23256(class_2561.class_2562.method_10867(textOnPage)));
				linesOnPage = 0;
				textOnPage = new class_2585("");
			}
		}

		if (linesOnPage > 0) {
			pages.add(class_2519.method_23256(class_2561.class_2562.method_10867(textOnPage)));
		}

		return pages;
	}
}
