package de.siphalor.spiceoffabric.foodhistory;

import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2554;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class FoodHistoryEntry {
	private int itemId;
	private class_2487 data;

	public FoodHistoryEntry() {
		itemId = 0;
		data = new class_2487();
	}

	public void write(class_2540 buffer) {
		buffer.method_10804(itemId);
	}

	public class_2554 getStackName() {
		return new class_2588(getStack().method_7922());
	}

	public class_1799 getStack() {
		class_1799 stack = new class_1799(class_2378.field_11142.method_10200(itemId));
		stack.method_7980(data);
		return stack;
	}

	public String getItemStackSerialization() {
		return "{id:\"" + class_2378.field_11142.method_10221(class_2378.field_11142.method_10200(itemId)) + "\",tag:" + data.method_10714() + ",Count:1}";
	}

	public static FoodHistoryEntry from(class_2540 buffer) {
		FoodHistoryEntry entry = new FoodHistoryEntry();
		entry.itemId = buffer.method_10816();
		return entry;
	}

	public class_2487 write(class_2487 compoundTag) {
        compoundTag.method_10582("item", class_2378.field_11142.method_10221(class_2378.field_11142.method_10200(itemId)).toString());
        compoundTag.method_10566("data", data);
		return compoundTag;
	}

	public FoodHistoryEntry read(class_2487 compoundTag) {
		Optional<class_1792> item = class_2378.field_11142.method_17966(class_2960.method_12829(compoundTag.method_10558("item")));
		if (item.isEmpty()) {
			return null;
		}
		itemId = class_2378.field_11142.method_10206(item.get());
		data = compoundTag.method_10562("data");
		return this;
	}

	public static FoodHistoryEntry fromItemStack(class_1799 stack) {
        FoodHistoryEntry entry = new FoodHistoryEntry();
        entry.itemId = class_2378.field_11142.method_10206(stack.method_7909());
		return entry;
	}

	@Override
	public boolean equals(Object other) {
		if(other instanceof FoodHistoryEntry)
			return ((FoodHistoryEntry) other).itemId == itemId && ((FoodHistoryEntry) other).data.equals(data);
        return super.equals(other);
	}

	@Override
	public int hashCode() {
		return Integer.valueOf(itemId).hashCode();
	}
}
