package de.siphalor.spiceoffabric.mixin;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

@Mixin(class_1702.class)
public abstract class MixinHungerManager implements IHungerManager {

	@Nullable
	protected class_3222 spiceOfFabric_player = null;

	@Shadow public abstract void add(int int_1, float float_1);

	@Shadow private float foodSaturationLevel;

	protected FoodHistory spiceOfFabric_foodHistory = new FoodHistory();

	@Override
	public void spiceOfFabric_setPlayer(class_3222 serverPlayerEntity) {
		spiceOfFabric_player = serverPlayerEntity;
	}

	@Override
	public void spiceOfFabric_clearHistory() {
		spiceOfFabric_foodHistory.reset();
	}

	@Override
	public void spiceOfFabric_setSaturationLevel(float level) {
		foodSaturationLevel = level;
	}

	@Override
	public FoodHistory spiceOfFabric_getFoodHistory() {
		return spiceOfFabric_foodHistory;
	}

	@Override
	public void spiceOfFabric_setFoodHistory(FoodHistory foodHistory) {
		spiceOfFabric_foodHistory = foodHistory;
	}

	@Inject(method = "eat", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/item/Item;getFoodComponent()Lnet/minecraft/item/FoodComponent;"), cancellable = true)
    public void onItemEat(class_1792 item, class_1799 stack, CallbackInfo callbackInfo) {
		Config.setHungerExpressionValues(spiceOfFabric_foodHistory.getTimesEaten(stack), Objects.requireNonNull(item.method_19264()).method_19230(), item.method_19264().method_19231(), stack.method_7935());
		int hunger = Config.getHungerValue();
		float saturation = Config.getSaturationValue();
		add(hunger, saturation);
		if (spiceOfFabric_player != null) {
			SpiceOfFabric.onEaten(spiceOfFabric_player, spiceOfFabric_foodHistory, stack);
		}
		callbackInfo.cancel();
	}

	@Inject(method = "readNbt", at = @At("RETURN"))
	public void onDeserialize(class_2487 data, CallbackInfo callbackInfo) {
		if(data.method_10573(SpiceOfFabric.NBT_FOOD_HISTORY_ID, 10)) {
			spiceOfFabric_foodHistory = FoodHistory.read(data.method_10562(SpiceOfFabric.NBT_FOOD_HISTORY_ID));

			if (spiceOfFabric_player != null) {
				class_1324 healthAttribute = spiceOfFabric_player.method_5996(
						class_5134.field_23716
				);
				if (healthAttribute == null) {
					System.err.println("[SOF] Players must have a maximum health!");
					return;
				}
				if (data.method_10545(SpiceOfFabric.NBT_VERSION_ID)) {
					if (Config.carrot.enable) {
						class_1322 modifier = healthAttribute.method_6199(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
						if (modifier == null) {
							SpiceOfFabric.updateMaxHealth(spiceOfFabric_player, false, false);
						}
					}
				} else { // Migrate from old system
					if (Config.carrot.enable) {
						healthAttribute.method_6200(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
						healthAttribute.method_6192(20D);
						healthAttribute.method_26837(new class_1322(
								SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID,
								SpiceOfFabric.MOD_ID,
								spiceOfFabric_foodHistory.getCarrotHealthOffset(spiceOfFabric_player),
								class_1322.class_1323.field_6328
						));
					}
				}
			}
		}

		if (spiceOfFabric_player != null) {
			((IServerPlayerEntity) spiceOfFabric_player).spiceOfFabric_scheduleFoodHistorySync();
		}
		/*if(Config.carrotEnabled.value && spiceOfFabric_foodHistory.carrotHistory == null) {
			spiceOfFabric_player.getAttributeInstance(EntityAttributes.MAX_HEALTH).setBaseValue(Config.startHearts.value * 2);
			spiceOfFabric_foodHistory.carrotHistory = new HashSet<>();
		}*/
	}

	@Inject(method = "writeNbt", at = @At("RETURN"))
	public void onSerialize(class_2487 data, CallbackInfo callbackInfo) {
		data.method_10566(SpiceOfFabric.NBT_FOOD_HISTORY_ID, spiceOfFabric_foodHistory.write(new class_2487()));
		data.method_10566(SpiceOfFabric.NBT_VERSION_ID, class_2497.method_23247(SpiceOfFabric.NBT_VERSION));
	}
}
