package de.siphalor.spiceoffabric.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_3222.class, priority = 1100)
public abstract class MixinServerPlayerEntity extends class_1657 implements IServerPlayerEntity {
	protected boolean spiceOfFabric_foodHistorySync = false;

	public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
		super(world, pos, yaw, profile);
	}

	@Override
	public void spiceOfFabric_scheduleFoodHistorySync() {
		spiceOfFabric_foodHistorySync = true;
	}

	@Override
	public boolean spiceOfFabric_foodHistorySync() {
		boolean result = spiceOfFabric_foodHistorySync;
		spiceOfFabric_foodHistorySync = false;
		return result;
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	public void onConstruct(MinecraftServer server, class_3218 world, GameProfile profile, CallbackInfo ci) {
		((IHungerManager) field_7493).spiceOfFabric_setPlayer((class_3222) (Object) this);

		if (Config.carrot.enable) {
			SpiceOfFabric.updateMaxHealth((class_3222)(Object) this, false, false);
			method_6033(method_6063());
		}
	}

	@Inject(method = "copyFrom", at = @At("RETURN"))
	public void onPlayerCopied(class_3222 reference, boolean exact, CallbackInfo callbackInfo) {
		if (!exact) {
			Pair<Double, Double> respawnHunger = Config.getRespawnHunger(reference.method_7344().method_7586(), reference.method_7344().method_7589());
			field_7493.method_7580((int) Math.max(respawnHunger.getFirst(), reference.method_7344().method_7586()));
			((IHungerManager) field_7493).spiceOfFabric_setSaturationLevel((float) (double) respawnHunger.getSecond());

			FoodHistory foodHistory = ((IHungerManager) reference.method_7344()).spiceOfFabric_getFoodHistory();

			if (Config.respawn.resetHistory) {
				foodHistory.resetHistory();
			}
			if (Config.respawn.resetCarrotMode) {
				foodHistory.resetCarrotHistory();
				class_1324 maxHealthAttr = method_5996(class_5134.field_23716);
				maxHealthAttr.method_6200(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
				maxHealthAttr.method_26837(
						SpiceOfFabric.createHealthModifier(foodHistory.getCarrotHealthOffset(((class_3222)(Object) this)))
				);
			}

			((IHungerManager) field_7493).spiceOfFabric_setFoodHistory(foodHistory);

			SpiceOfFabric.syncFoodHistory((class_3222) (Object) this);
		}
	}
}
