package de.siphalor.spiceoffabric.server;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.util.IHungerManager;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import java.util.Collection;
import java.util.Collections;

public class Commands {
	public static void register() {
		CommandRegistrationCallback.EVENT.register((commandDispatcher, dedicated) -> {
			commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":clear_history")
					.requires(source -> source.method_9259(2))
					.executes(context ->
							clearHistory(
									context.getSource(),
									Collections.singleton(context.getSource().method_9207())
							)
					).then(
							class_2170.method_9244("targets", class_2186.method_9308())
									.executes(context ->
											clearHistory(
													context.getSource(),
													class_2186.method_9312(context, "targets")
											)
									)
					)
			);
			commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":set_base_max_health")
					.requires(source -> source.method_9259(2))
					.then(
							class_2170.method_9244("targets", class_2186.method_9308())
									.then(
											class_2170.method_9244("amount", IntegerArgumentType.integer(1, 200))
													.executes(context ->
															setBaseMaxHealth(
																	context.getSource(),
																	class_2186.method_9312(context, "targets"),
																	IntegerArgumentType.getInteger(context, "amount")
															)
													)
									)
					)
					.then(
							class_2170.method_9244("amount", IntegerArgumentType.integer(1, 200))
									.executes(context ->
											setBaseMaxHealth(
													context.getSource(),
													Collections.singleton(context.getSource().method_9207()),
													IntegerArgumentType.getInteger(context, "amount")
											)
									)
					)
			);
			commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":update_max_health")
					.requires(source -> source.method_9259(2))
					.executes(context ->
							updateMaxHealth(context.getSource(), Collections.singleton(context.getSource().method_9207()))
					).then(
							class_2170.method_9244("targets", class_2186.method_9308())
									.executes(context ->
											updateMaxHealth(context.getSource(), class_2186.method_9312(context, "targets"))
									)
					)
			);
		});
	}

	private static int clearHistory(class_2168 commandSource, Collection<class_3222> players) {
		for (class_3222 player : players) {
			((IHungerManager) player.method_7344()).spiceOfFabric_clearHistory();
			if (Config.carrot.enable) {
				SpiceOfFabric.updateMaxHealth(player, true, true);
			}
			if (ServerPlayNetworking.canSend(player, SpiceOfFabric.CLEAR_FOODS_S2C_PACKET)) {
				ServerPlayNetworking.send(player, SpiceOfFabric.CLEAR_FOODS_S2C_PACKET, new class_2540(Unpooled.buffer()));
				player.method_7353(new class_2588("spiceoffabric.command.clear_history.was_cleared"), false);
			} else {
				player.method_7353(new class_2585("Your food history has been cleared"), false);
			}
		}

		try {
			if (commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasMod(commandSource.method_9207())) {
				commandSource.method_9226(new class_2588("spiceoffabric.command.clear_history.cleared_players", players.size()), true);
			} else {
				commandSource.method_9226(new class_2585("Cleared food histories of " + players.size() + " players."), true);
			}
		} catch (CommandSyntaxException e) {
			e.printStackTrace();
		}
		return players.size();
	}

	private static int setBaseMaxHealth(class_2168 commandSource, Collection<class_3222> players, int amount) {
		for (class_3222 player : players) {
			class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
			//noinspection ConstantConditions
			maxHealthAttr.method_6192(amount);
			if (Config.carrot.enable) {
				SpiceOfFabric.updateMaxHealth(player, true, true);
			}
			if (SpiceOfFabric.hasMod(player)) {
				player.method_7353(new class_2588("spiceoffabric.command.set_base_max_health.target"), false);
			} else {
				player.method_7353(new class_2585("Your health has been adjusted"), false);
			}
		}

		try {
			if (commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasMod(commandSource.method_9207())) {
				commandSource.method_9226(new class_2588("spiceoffabric.command.set_base_max_health.executor", players.size(), amount, amount / 2D), false);
			} else {
				commandSource.method_9226(new class_2585("Set base health of %d players to %d (%s hearts)".formatted(players.size(), amount, amount / 2D)), false);
			}
		} catch (CommandSyntaxException e) {
			e.printStackTrace();
		}
		return players.size();
	}

	private static int updateMaxHealth(class_2168 commandSource, Collection<class_3222> players) {
		boolean sourceHasMod;
		try {
			sourceHasMod = commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasMod(commandSource.method_9207());
		} catch (CommandSyntaxException e) {
			sourceHasMod = false;
		}

		if (!Config.carrot.enable) {
			if (sourceHasMod) {
				commandSource.method_9213(new class_2588("spiceoffabric.commands.carrot_not_enabled"));
			} else {
				commandSource.method_9213(new class_2585("Carrot mode is not enabled!"));
			}
			return 0;
		}
		for (class_3222 player : players) {
			SpiceOfFabric.updateMaxHealth(player, true, true);
		}
		if (sourceHasMod) {
			commandSource.method_9226(new class_2588("spiceoffabric.command.update_max_health.success", players.size()), false);
		} else {
			commandSource.method_9226(new class_2585("Refreshed the max health of " + players.size() + " players"), false);
		}
		return players.size();
	}
}
