/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.foodhistory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class FoodHistory {
    public Set<FoodHistoryEntry> carrotHistory;
    public BiMap<Integer, FoodHistoryEntry> dictionary;
    public int nextId = 0;
    public Queue<Integer> history;
    public Map<Integer, Integer> stats;

    public FoodHistory() {
        this.setup();
    }

    public void setup() {
        this.dictionary = HashBiMap.create();
        this.history = new ConcurrentLinkedQueue<Integer>();
        this.stats = new Int2IntArrayMap();
        this.carrotHistory = new HashSet<FoodHistoryEntry>();
    }

    public void reset() {
        this.resetHistory();
        this.resetCarrotHistory();
    }

    public void resetHistory() {
        this.dictionary.clear();
        this.nextId = 0;
        this.history.clear();
        this.stats.clear();
    }

    public void resetCarrotHistory() {
        this.carrotHistory.clear();
    }

    public void write(class_2540 buffer) {
        buffer.method_10804(this.dictionary.size());
        for (Map.Entry entry : this.dictionary.entrySet()) {
            buffer.method_10804(((Integer)entry.getKey()).intValue());
            ((FoodHistoryEntry)entry.getValue()).write(buffer);
        }
        buffer.method_10804(this.history.size());
        Iterator<Object> iterator = this.history.iterator();
        while (iterator.hasNext()) {
            int integer = (Integer)iterator.next();
            buffer.method_10804(integer);
        }
        if (Config.carrot.enable) {
            buffer.writeBoolean(true);
            buffer.method_10804(this.carrotHistory.size());
            for (FoodHistoryEntry entry : this.carrotHistory) {
                entry.write(buffer);
            }
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void read(class_2540 buffer) {
        int i;
        int l = buffer.method_10816();
        for (i = 0; i < l; ++i) {
            this.dictionary.put((Object)buffer.method_10816(), (Object)FoodHistoryEntry.from(buffer));
        }
        l = buffer.method_10816();
        for (i = 0; i < l; ++i) {
            this.history.offer(buffer.method_10816());
        }
        if (buffer.readBoolean()) {
            int length = buffer.method_10816();
            this.carrotHistory = new HashSet<FoodHistoryEntry>(length);
            for (i = 0; i < length; ++i) {
                this.carrotHistory.add(FoodHistoryEntry.from(buffer));
            }
        }
        this.buildStats();
    }

    public class_2487 write(class_2487 compoundTag) {
        this.defragmentDictionary();
        class_2499 list = new class_2499();
        for (Object entry : this.dictionary.entrySet()) {
            list.method_10531(((Integer)entry.getKey()).intValue(), (class_2520)((FoodHistoryEntry)entry.getValue()).write(new class_2487()));
        }
        compoundTag.method_10566("dictionary", (class_2520)list);
        class_2499 historyList = new class_2499();
        for (Integer id : this.history) {
            historyList.add((Object)class_2497.method_23247((int)id));
        }
        compoundTag.method_10566("history", (class_2520)historyList);
        class_2499 carrotHistoryList = new class_2499();
        for (FoodHistoryEntry entry : this.carrotHistory) {
            carrotHistoryList.add((Object)entry.write(new class_2487()));
        }
        compoundTag.method_10566("carrotHistory", (class_2520)carrotHistoryList);
        return compoundTag;
    }

    public static FoodHistory read(class_2487 compoundTag) {
        FoodHistory foodHistory = new FoodHistory();
        class_2499 list = (class_2499)compoundTag.method_10580("dictionary");
        for (int i = 0; i < list.size(); ++i) {
            FoodHistoryEntry entry = new FoodHistoryEntry().read(list.method_10602(i));
            if (entry == null) continue;
            foodHistory.dictionary.put((Object)i, (Object)entry);
        }
        foodHistory.nextId = foodHistory.dictionary.size();
        list = (class_2499)compoundTag.method_10580("history");
        for (class_2520 tag : list) {
            foodHistory.history.offer(((class_2497)tag).method_10701());
        }
        foodHistory.buildStats();
        if (compoundTag.method_10545("carrotHistory")) {
            list = (class_2499)compoundTag.method_10580("carrotHistory");
            if (Config.carrot.enable) {
                foodHistory.carrotHistory = new HashSet<FoodHistoryEntry>(list.size());
                for (class_2520 tag : list) {
                    foodHistory.carrotHistory.add(new FoodHistoryEntry().read((class_2487)tag));
                }
            }
        }
        return foodHistory;
    }

    public void buildStats() {
        this.stats.clear();
        for (Integer id : this.history) {
            if (this.stats.containsKey(id)) {
                this.stats.put(id, this.stats.get(id) + 1);
                continue;
            }
            this.stats.put(id, 1);
        }
    }

    public void defragmentDictionary() {
        Integer id2;
        HashMap<Integer, Integer> oldToNewMap = new HashMap<Integer, Integer>();
        int i = 0;
        for (Integer id2 : this.dictionary.keySet()) {
            oldToNewMap.put(id2, i);
            ++i;
        }
        this.nextId = i;
        ConcurrentLinkedQueue<Integer> newHistory = new ConcurrentLinkedQueue<Integer>();
        while ((id2 = this.history.poll()) != null) {
            newHistory.offer(id2);
        }
        this.history = newHistory;
        Int2IntArrayMap newStats = new Int2IntArrayMap();
        for (Map.Entry<Integer, Integer> entry : this.stats.entrySet()) {
            newStats.put((Integer)oldToNewMap.get(entry.getKey()), entry.getValue());
        }
        this.stats = newStats;
        HashBiMap newDictionary = HashBiMap.create();
        for (Map.Entry entry : this.dictionary.entrySet()) {
            newDictionary.put((Object)((Integer)oldToNewMap.get(entry.getKey())), (Object)((FoodHistoryEntry)entry.getValue()));
        }
        this.dictionary = newDictionary;
    }

    public int getTimesEaten(class_1799 stack) {
        return this.stats.getOrDefault(this.dictionary.inverse().get((Object)FoodHistoryEntry.fromItemStack(stack)), 0);
    }

    public void addFood(class_1799 stack, class_3222 serverPlayerEntity) {
        FoodHistoryEntry entry = FoodHistoryEntry.fromItemStack(stack);
        if (ServerPlayNetworking.canSend((class_3222)serverPlayerEntity, (class_2960)SpiceOfFabric.ADD_FOOD_S2C_PACKET)) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            entry.write(buffer);
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)SpiceOfFabric.ADD_FOOD_S2C_PACKET, (class_2540)buffer);
        }
        this.addFood(entry);
    }

    public void addFood(FoodHistoryEntry entry) {
        Integer id = (Integer)this.dictionary.inverse().get((Object)entry);
        if (id == null) {
            id = this.nextId++;
            this.dictionary.put((Object)id, (Object)entry);
        }
        this.history.offer(id);
        while (this.history.size() > Config.food.historyLength) {
            this.removeLastFood();
        }
        this.stats.put(id, this.stats.getOrDefault(id, 0) + 1);
        if (Config.carrot.enable) {
            this.carrotHistory.add(entry);
        }
    }

    public void removeLastFood() {
        int id = this.history.remove();
        if (this.stats.containsKey(id)) {
            this.stats.put(id, this.stats.get(id) - 1);
        }
    }

    public int getCarrotHealthOffset(class_1657 player) {
        class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
        Config.setHealthFormulaExpressionValues(this.carrotHistory.size(), (int)maxHealthAttr.method_6201());
        return Math.max(1, class_3532.method_15357((double)Config.healthFormulaExpression.evaluate())) - (int)maxHealthAttr.method_6201();
    }

    public int getCarrotMaxHealth(class_1657 player) {
        class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
        Config.setHealthFormulaExpressionValues(this.carrotHistory.size(), (int)maxHealthAttr.method_6201());
        return class_3532.method_15357((double)Config.healthFormulaExpression.evaluate());
    }

    public class_2499 genJournalPages(class_1657 playerEntity) {
        boolean hasMod = ServerPlayNetworking.canSend((class_3222)((class_3222)playerEntity), (class_2960)SpiceOfFabric.ADD_FOOD_S2C_PACKET);
        class_2499 pages = new class_2499();
        class_2585 textOnPage = new class_2585("");
        textOnPage.method_10852((class_2561)(hasMod ? new class_2588("spiceoffabric.journal.inside_title") : new class_2585("\u25b6 Diet Journal \u25c0").method_10862(class_2583.field_24360.method_10977(class_124.field_1063).method_27706(class_124.field_1073).method_10982(Boolean.valueOf(true)))));
        textOnPage.method_27693("\n\n");
        class_2583 numberStyle = class_2583.field_24360.method_10982(Boolean.valueOf(true));
        class_2583 itemStyle = class_2583.field_24360.method_10977(class_124.field_1063);
        int linesOnPage = 2;
        int number = 1;
        Iterator iterator = this.history.iterator();
        while (iterator.hasNext()) {
            int foodId = (Integer)iterator.next();
            FoodHistoryEntry entry = (FoodHistoryEntry)this.dictionary.get((Object)foodId);
            if (hasMod) {
                textOnPage.method_10852((class_2561)new class_2588("spiceoffabric.journal.line", new Object[]{number, entry.getStackName()}).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(entry.getStack()))))).method_27693("\n");
            } else {
                textOnPage.method_10852((class_2561)new class_2585(number + ". ").method_10862(numberStyle)).method_10852((class_2561)entry.getStackName().method_10862(itemStyle.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(entry.getStack()))).method_10982(Boolean.valueOf(false)))).method_27693("\n");
            }
            ++number;
            if (++linesOnPage < 14) continue;
            pages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)textOnPage)));
            linesOnPage = 0;
            textOnPage = new class_2585("");
        }
        if (linesOnPage > 0) {
            pages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)textOnPage)));
        }
        return pages;
    }
}

