/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.mixin;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import java.util.Objects;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
public abstract class MixinHungerManager
implements IHungerManager {
    @Nullable
    protected class_3222 spiceOfFabric_player = null;
    @Shadow
    private float field_7753;
    protected FoodHistory spiceOfFabric_foodHistory = new FoodHistory();

    @Shadow
    public abstract void method_7585(int var1, float var2);

    @Override
    public void spiceOfFabric_setPlayer(class_3222 serverPlayerEntity) {
        this.spiceOfFabric_player = serverPlayerEntity;
    }

    @Override
    public void spiceOfFabric_clearHistory() {
        this.spiceOfFabric_foodHistory.reset();
    }

    @Override
    public void spiceOfFabric_setSaturationLevel(float level) {
        this.field_7753 = level;
    }

    @Override
    public FoodHistory spiceOfFabric_getFoodHistory() {
        return this.spiceOfFabric_foodHistory;
    }

    @Override
    public void spiceOfFabric_setFoodHistory(FoodHistory foodHistory) {
        this.spiceOfFabric_foodHistory = foodHistory;
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/item/Item;getFoodComponent()Lnet/minecraft/item/FoodComponent;")}, cancellable=true)
    public void onItemEat(class_1792 item, class_1799 stack, CallbackInfo callbackInfo) {
        Config.setHungerExpressionValues(this.spiceOfFabric_foodHistory.getTimesEaten(stack), Objects.requireNonNull(item.method_19264()).method_19230(), item.method_19264().method_19231(), stack.method_7935());
        int hunger = Config.getHungerValue();
        float saturation = Config.getSaturationValue();
        this.method_7585(hunger, saturation);
        if (this.spiceOfFabric_player != null) {
            SpiceOfFabric.onEaten(this.spiceOfFabric_player, this.spiceOfFabric_foodHistory, stack);
        }
        callbackInfo.cancel();
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    public void onDeserialize(class_2487 data, CallbackInfo callbackInfo) {
        if (data.method_10573("spiceOfFabric_history", 10)) {
            this.spiceOfFabric_foodHistory = FoodHistory.read(data.method_10562("spiceOfFabric_history"));
            if (this.spiceOfFabric_player != null) {
                class_1324 healthAttribute = this.spiceOfFabric_player.method_5996(class_5134.field_23716);
                if (healthAttribute == null) {
                    System.err.println("[SOF] Players must have a maximum health!");
                    return;
                }
                if (data.method_10545("spiceOfFabric_version")) {
                    class_1322 modifier;
                    if (Config.carrot.enable && (modifier = healthAttribute.method_6199(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID)) == null) {
                        SpiceOfFabric.updateMaxHealth(this.spiceOfFabric_player, false, false);
                    }
                } else if (Config.carrot.enable) {
                    healthAttribute.method_6200(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
                    healthAttribute.method_6192(20.0);
                    healthAttribute.method_26837(new class_1322(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID, "spiceoffabric", (double)this.spiceOfFabric_foodHistory.getCarrotHealthOffset((class_1657)this.spiceOfFabric_player), class_1322.class_1323.field_6328));
                }
            }
        }
        if (this.spiceOfFabric_player != null) {
            ((IServerPlayerEntity)this.spiceOfFabric_player).spiceOfFabric_scheduleFoodHistorySync();
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void onSerialize(class_2487 data, CallbackInfo callbackInfo) {
        data.method_10566("spiceOfFabric_history", (class_2520)this.spiceOfFabric_foodHistory.write(new class_2487()));
        data.method_10566("spiceOfFabric_version", (class_2520)class_2497.method_23247((int)1));
    }
}

