/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.server;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.Config;
import de.siphalor.spiceoffabric.util.IHungerManager;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Collections;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class Commands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, dedicated) -> {
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spiceoffabric:clear_history").requires(source -> source.method_9259(2))).executes(context -> Commands.clearHistory((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> Commands.clearHistory((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets")))));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spiceoffabric:set_base_max_health").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(context -> Commands.setBaseMaxHealth((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(context -> Commands.setBaseMaxHealth((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_9207()), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spiceoffabric:update_max_health").requires(source -> source.method_9259(2))).executes(context -> Commands.updateMaxHealth((class_2168)context.getSource(), Collections.singleton(((class_2168)context.getSource()).method_9207())))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(context -> Commands.updateMaxHealth((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets")))));
        });
    }

    private static int clearHistory(class_2168 commandSource, Collection<class_3222> players) {
        for (class_3222 player : players) {
            ((IHungerManager)player.method_7344()).spiceOfFabric_clearHistory();
            if (Config.carrot.enable) {
                SpiceOfFabric.updateMaxHealth(player, true, true);
            }
            if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)SpiceOfFabric.CLEAR_FOODS_S2C_PACKET)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)SpiceOfFabric.CLEAR_FOODS_S2C_PACKET, (class_2540)new class_2540(Unpooled.buffer()));
                player.method_7353((class_2561)new class_2588("spiceoffabric.command.clear_history.was_cleared"), false);
                continue;
            }
            player.method_7353((class_2561)new class_2585("Your food history has been cleared"), false);
        }
        try {
            if (commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasMod(commandSource.method_9207())) {
                commandSource.method_9226((class_2561)new class_2588("spiceoffabric.command.clear_history.cleared_players", new Object[]{players.size()}), true);
            } else {
                commandSource.method_9226((class_2561)new class_2585("Cleared food histories of " + players.size() + " players."), true);
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return players.size();
    }

    private static int setBaseMaxHealth(class_2168 commandSource, Collection<class_3222> players, int amount) {
        for (class_3222 player : players) {
            class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
            maxHealthAttr.method_6192((double)amount);
            if (Config.carrot.enable) {
                SpiceOfFabric.updateMaxHealth(player, true, true);
            }
            if (SpiceOfFabric.hasMod(player)) {
                player.method_7353((class_2561)new class_2588("spiceoffabric.command.set_base_max_health.target"), false);
                continue;
            }
            player.method_7353((class_2561)new class_2585("Your health has been adjusted"), false);
        }
        try {
            if (commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasMod(commandSource.method_9207())) {
                commandSource.method_9226((class_2561)new class_2588("spiceoffabric.command.set_base_max_health.executor", new Object[]{players.size(), amount, (double)amount / 2.0}), false);
            } else {
                commandSource.method_9226((class_2561)new class_2585("Set base health of %d players to %d (%s hearts)".formatted(players.size(), amount, (double)amount / 2.0)), false);
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return players.size();
    }

    private static int updateMaxHealth(class_2168 commandSource, Collection<class_3222> players) {
        boolean sourceHasMod;
        try {
            sourceHasMod = commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasMod(commandSource.method_9207());
        }
        catch (CommandSyntaxException e) {
            sourceHasMod = false;
        }
        if (!Config.carrot.enable) {
            if (sourceHasMod) {
                commandSource.method_9213((class_2561)new class_2588("spiceoffabric.commands.carrot_not_enabled"));
            } else {
                commandSource.method_9213((class_2561)new class_2585("Carrot mode is not enabled!"));
            }
            return 0;
        }
        for (class_3222 player : players) {
            SpiceOfFabric.updateMaxHealth(player, true, true);
        }
        if (sourceHasMod) {
            commandSource.method_9226((class_2561)new class_2588("spiceoffabric.command.update_max_health.success", new Object[]{players.size()}), false);
        } else {
            commandSource.method_9226((class_2561)new class_2585("Refreshed the max health of " + players.size() + " players"), false);
        }
        return players.size();
    }
}

