/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.capsaicin.api.food.FoodEvents;
import de.siphalor.capsaicin.api.food.FoodModifications;
import de.siphalor.capsaicin.api.food.FoodProperties;
import de.siphalor.capsaicin.api.food.PlayerFoodModifier;
import de.siphalor.capsaicin.api.modifier.Modifier;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.polymer.SOFPolymer;
import de.siphalor.spiceoffabric.recipe.FoodJournalRecipeSerializer;
import de.siphalor.spiceoffabric.server.SOFCommands;
import de.siphalor.spiceoffabric.util.FoodUtils;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.tweed4.Tweed;
import de.siphalor.tweed4.config.ConfigEnvironment;
import de.siphalor.tweed4.config.ConfigFile;
import de.siphalor.tweed4.config.ConfigLoader;
import de.siphalor.tweed4.config.TweedRegistry;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.attribute.EntityAttributeInstance;
import net.minecraft.entity.attribute.EntityAttributeModifier;
import net.minecraft.entity.attribute.EntityAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FoodComponent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemGroups;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.s2c.play.EntityAttributesS2CPacket;
import net.minecraft.network.packet.s2c.play.HealthUpdateS2CPacket;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvents;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiceOfFabric
implements ModInitializer {
    public static final String MOD_ID = "spiceoffabric";
    public static final String NBT_FOOD_HISTORY_ID = "spiceOfFabric_history";
    public static final String NBT_VERSION_ID = "spiceOfFabric_version";
    public static final int NBT_VERSION = 1;
    public static final String FOOD_JOURNAL_FLAG = "spiceoffabric:food_journal";
    public static final UUID PLAYER_HEALTH_MODIFIER_UUID = UUID.nameUUIDFromBytes("spiceoffabric".getBytes(StandardCharsets.UTF_8));
    public static final Logger LOGGER = LoggerFactory.getLogger(SpiceOfFabric.class);
    private static final FoodComponent EMPTY_FOOD_COMPONENT = new FoodComponent.Builder().build();
    public static Item[] foodContainerItems;

    public void onInitialize() {
        SpiceOfFabric.initConfig();
        SOFCommonNetworking.init();
        SOFCommands.register();
        SpiceOfFabric.initResourceConditions();
        SpiceOfFabric.initRecipes();
        SpiceOfFabric.initFoodEvents();
        if (SOFConfig.items.usePolymer) {
            if (!FabricLoader.getInstance().isModLoaded("polymer")) {
                LOGGER.error("Polymer is not installed, but Polymer usage is enabled in the Spice of Fabric config!");
                System.exit(1);
            }
            SOFPolymer.init();
        } else {
            SpiceOfFabric.initNativeFoodContainerItems();
        }
        SpiceOfFabric.initItemGroups();
    }

    private static void initConfig() {
        Tweed.runEntryPoints();
        FabricLoader loader = FabricLoader.getInstance();
        ConfigLoader.initialReload((ConfigFile)TweedRegistry.getConfigFile((String)MOD_ID), (ConfigEnvironment)(loader.getEnvironmentType() == EnvType.SERVER ? ConfigEnvironment.SERVER : ConfigEnvironment.UNIVERSAL));
    }

    private static void initResourceConditions() {
        ResourceConditions.register((Identifier)new Identifier(MOD_ID, "registry_populated"), optionsJson -> {
            Identifier id = new Identifier(JsonHelper.getString((JsonObject)optionsJson, (String)"registry"));
            Registry registry = (Registry)Registries.REGISTRIES.get(id);
            if (registry == null) {
                throw new JsonSyntaxException(id + " is not a valid registry!");
            }
            for (JsonElement elementJson : JsonHelper.getArray((JsonObject)optionsJson, (String)"ids")) {
                Identifier elementId = new Identifier(JsonHelper.asString((JsonElement)elementJson, (String)"id"));
                if (registry.containsId(elementId)) continue;
                return false;
            }
            return true;
        });
    }

    private static void initRecipes() {
        Registry.register((Registry)Registries.RECIPE_SERIALIZER, (Identifier)new Identifier(MOD_ID, "food_journal"), (Object)new FoodJournalRecipeSerializer());
    }

    private static void initNativeFoodContainerItems() {
        ArrayList<Item> foodContainerItems = new ArrayList<Item>(4);
        if (SOFConfig.items.enablePaperBag) {
            foodContainerItems.add((Item)Registry.register((Registry)Registries.ITEM, (Identifier)new Identifier(MOD_ID, "paper_bag"), (Object)((Object)new FoodContainerItem(new Item.Settings().maxCount(1).food(EMPTY_FOOD_COMPONENT), 5, ScreenHandlerType.HOPPER))));
        }
        if (SOFConfig.items.enableLunchBox) {
            foodContainerItems.add((Item)Registry.register((Registry)Registries.ITEM, (Identifier)new Identifier(MOD_ID, "lunch_box"), (Object)((Object)new FoodContainerItem(new Item.Settings().maxCount(1).food(EMPTY_FOOD_COMPONENT), 9, ScreenHandlerType.GENERIC_3X3))));
        }
        if (SOFConfig.items.enablePicnicBasket) {
            foodContainerItems.add((Item)Registry.register((Registry)Registries.ITEM, (Identifier)new Identifier(MOD_ID, "picnic_basket"), (Object)((Object)new FoodContainerItem(new Item.Settings().maxCount(1).food(EMPTY_FOOD_COMPONENT), 9, ScreenHandlerType.GENERIC_3X3))));
        }
        SpiceOfFabric.foodContainerItems = foodContainerItems.toArray(new Item[0]);
    }

    private static void initItemGroups() {
        ItemGroupEvents.modifyEntriesEvent((RegistryKey)ItemGroups.FOOD_AND_DRINK).register(entries -> {
            entries.add(SpiceOfFabric.createFoodJournalStack());
            for (Item item : foodContainerItems) {
                entries.add((ItemConvertible)item);
            }
        });
    }

    private static void initFoodEvents() {
        FoodEvents.EATEN.on(SpiceOfFabric::onFoodEaten);
        FoodModifications.EATING_TIME_MODIFIERS.register((Modifier)((PlayerFoodModifier)SpiceOfFabric::modifyEatingTime), new Identifier(MOD_ID, "config_expression"));
        FoodModifications.PROPERTIES_MODIFIERS.register(SpiceOfFabric::modifyFoodProperties, new Identifier(MOD_ID, "config_expression"));
    }

    private static void onFoodEaten(FoodEvents.Eaten event) {
        FoodContext context = event.context();
        LivingEntity livingEntity = context.user();
        if (livingEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)livingEntity;
            FoodHistory foodHistory = FoodHistory.get((PlayerEntity)player);
            ItemStack foodStack = FoodUtils.getFoodStack(context);
            foodHistory.addFood(foodStack, player);
            if (SOFConfig.carrot.enable && (player.getMaxHealth() < (float)SOFConfig.carrot.maxHealth || SOFConfig.carrot.maxHealth == -1)) {
                SpiceOfFabric.updateMaxHealth(player, true, true);
            }
        }
    }

    private static Integer modifyEatingTime(Integer eatingTime, FoodContext context, PlayerEntity player) {
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return eatingTime;
        }
        SOFConfig.setConsumeDurationValues(foodHistory.getTimesRecentlyEaten(FoodUtils.getFoodStack(context)), context.originalFoodHunger(), context.originalFoodSaturationModifier(), eatingTime);
        return (int)SOFConfig.consumeDurationExpression.evaluate();
    }

    private static FoodProperties modifyFoodProperties(FoodProperties foodProperties, FoodContext context) {
        PlayerEntity player;
        FoodHistory foodHistory;
        LivingEntity livingEntity = context.user();
        int timesEaten = livingEntity instanceof PlayerEntity ? ((foodHistory = FoodHistory.get(player = (PlayerEntity)livingEntity)) != null ? foodHistory.getTimesRecentlyEaten(FoodUtils.getFoodStack(context)) : 0) : 0;
        SOFConfig.setHungerExpressionValues(timesEaten, foodProperties.getHunger(), foodProperties.getSaturationModifier(), 0);
        foodProperties.setHunger(SOFConfig.getHungerValue());
        foodProperties.setSaturationModifier(SOFConfig.getSaturationValue());
        return foodProperties;
    }

    public static boolean hasClientMod(ServerPlayerEntity player) {
        return SOFCommonNetworking.hasClientMod(player);
    }

    public static EntityAttributeModifier createHealthModifier(double amount) {
        return new EntityAttributeModifier(PLAYER_HEALTH_MODIFIER_UUID, MOD_ID, amount, EntityAttributeModifier.Operation.ADDITION);
    }

    public static void updateMaxHealth(ServerPlayerEntity player, boolean sync, boolean announce) {
        EntityAttributeInstance maxHealthAttr = player.getAttributeInstance(EntityAttributes.GENERIC_MAX_HEALTH);
        double oldValue = maxHealthAttr.getValue();
        maxHealthAttr.removeModifier(PLAYER_HEALTH_MODIFIER_UUID);
        if (SOFConfig.carrot.enable) {
            FoodHistory foodHistory = ((IHungerManager)player.getHungerManager()).spiceOfFabric_getFoodHistory();
            maxHealthAttr.addPersistentModifier(SpiceOfFabric.createHealthModifier(foodHistory.getCarrotHealthOffset((PlayerEntity)player)));
        }
        if (sync) {
            player.networkHandler.sendPacket((Packet)new EntityAttributesS2CPacket(player.getId(), Collections.singleton(maxHealthAttr)));
            player.networkHandler.sendPacket((Packet)new HealthUpdateS2CPacket(player.getHealth(), player.getHungerManager().getFoodLevel(), player.getHungerManager().getSaturationLevel()));
        }
        if (announce && maxHealthAttr.getValue() > oldValue) {
            player.getWorld().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static boolean isFoodJournal(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        NbtCompound nbt = stack.getNbt();
        return nbt != null && nbt.contains(FOOD_JOURNAL_FLAG, 1) && nbt.getBoolean(FOOD_JOURNAL_FLAG);
    }

    public static ItemStack createFoodJournalStack() {
        ItemStack stack = new ItemStack((ItemConvertible)Items.WRITTEN_BOOK);
        NbtCompound compound = stack.getOrCreateNbt();
        compound.putString("title", "");
        compound.putString("author", "Me");
        compound.putBoolean(FOOD_JOURNAL_FLAG, true);
        stack.getOrCreateSubNbt("display").putString("Name", "{\"translate\":\"Diet Journal\",\"bold\":true}");
        return stack;
    }
}

