/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.client;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import de.siphalor.spiceoffabric.networking.SOFClientNetworking;
import de.siphalor.spiceoffabric.util.FoodUtils;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.item.ClampedModelPredicateProvider;
import net.minecraft.client.item.ModelPredicateProviderRegistry;
import net.minecraft.client.item.TooltipContext;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;

public class SOFClient
implements ClientModInitializer {
    public void onInitializeClient() {
        SOFClientNetworking.init();
        ItemTooltipCallback.EVENT.register(SOFClient::itemTooltipCallback);
        SOFClient.initRendering();
    }

    private static void itemTooltipCallback(ItemStack stack, TooltipContext context, List<Text> lines) {
        lines.addAll(1, FoodUtils.getClientTooltipAdditions((PlayerEntity)MinecraftClient.getInstance().player, stack));
    }

    private static void initRendering() {
        if (!SOFConfig.items.usePolymer && SpiceOfFabric.foodContainerItems != null) {
            SOFClient.registerModelPredicateProviders();
        }
    }

    private static void registerModelPredicateProviders() {
        ClampedModelPredicateProvider predicateProvider = (stack, world, entity, seed) -> ((FoodContainerItem)stack.getItem()).isInventoryEmpty(stack) ? 0.0f : 1.0f;
        Identifier predicateId = new Identifier("spiceoffabric", "filled");
        for (Item item : SpiceOfFabric.foodContainerItems) {
            ModelPredicateProviderRegistry.register((Item)item, (Identifier)predicateId, (ClampedModelPredicateProvider)predicateProvider);
        }
    }
}

