/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.container.ItemStackInventory;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.screen.NamedScreenHandlerFactory;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.screen.slot.Slot;
import net.minecraft.text.Text;
import org.jetbrains.annotations.Nullable;

public class FoodContainerScreenHandler
extends ScreenHandler {
    private final FoodContainerItem foodContainerItem;

    public FoodContainerScreenHandler(FoodContainerItem foodContainerItem, int syncId, PlayerInventory playerInventory, ItemStack containerStack) {
        super(foodContainerItem.getScreenHandlerType(), syncId);
        int i;
        this.foodContainerItem = foodContainerItem;
        ItemStackInventory inventory = foodContainerItem.getInventory(containerStack);
        for (i = 0; i < foodContainerItem.getSize(); ++i) {
            this.addSlot(new FoodSlot(inventory, i, 0, 0));
        }
        for (i = 9; i < 36; ++i) {
            this.addSlot(new Slot((Inventory)playerInventory, i, 0, 0));
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Inventory)playerInventory, i, 0, 0));
        }
    }

    public boolean canUse(PlayerEntity player) {
        return true;
    }

    public ItemStack quickMove(PlayerEntity player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasStack()) {
            ItemStack moveStack = slot.getStack();
            result = moveStack.copy();
            if (index < this.foodContainerItem.getSize() ? !this.insertItem(moveStack, this.foodContainerItem.getSize(), this.slots.size(), true) : !this.insertItem(moveStack, 0, this.foodContainerItem.getSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (moveStack.isEmpty()) {
                slot.setStack(ItemStack.EMPTY);
            } else {
                slot.markDirty();
            }
        }
        return result;
    }

    private static class FoodSlot
    extends Slot {
        public FoodSlot(Inventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean canInsert(ItemStack stack) {
            return this.inventory.isValid(this.getIndex(), stack);
        }
    }

    public static class Factory
    implements NamedScreenHandlerFactory {
        private final ItemStack containerStack;
        private final FoodContainerItem foodContainerItem;

        public Factory(FoodContainerItem foodContainerItem, ItemStack containerStack) {
            this.containerStack = containerStack;
            this.foodContainerItem = foodContainerItem;
        }

        public Text getDisplayName() {
            return this.containerStack.getName();
        }

        @Nullable
        public ScreenHandler createMenu(int syncId, PlayerInventory playerInventory, PlayerEntity player) {
            return new FoodContainerScreenHandler(this.foodContainerItem, syncId, playerInventory, this.containerStack);
        }
    }
}

