/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.container.ClickableSlot;
import de.siphalor.spiceoffabric.container.FoodJournalView;
import de.siphalor.spiceoffabric.container.PaginatedReadOnlyInventory;
import de.siphalor.spiceoffabric.container.ReadOnlySlot;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.util.FoodUtils;
import de.siphalor.spiceoffabric.util.IHungerManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.SimpleInventory;
import net.minecraft.item.FoodComponent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.registry.Registries;
import net.minecraft.screen.NamedScreenHandlerFactory;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.screen.slot.Slot;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;
import org.jetbrains.annotations.Nullable;

public class FoodJournalScreenHandler
extends ScreenHandler {
    private static final String PAGE_INDICATOR_TEXT_KEY = "book.pageIndicator";
    private static final Item PAGE_INDICATOR_ITEM = Items.STICK;
    private static final ItemStack PREV_STACK = new ItemStack((ItemConvertible)Items.FEATHER);
    private static final ItemStack NEXT_STACK;
    private static final int JOURNAL_SLOT_COUNT = 45;
    private final ServerPlayerEntity player;
    private final boolean clientHasMod;
    private final FoodJournalView currentView;
    private final PaginatedReadOnlyInventory foodJournalInventory;
    private final Inventory infoInventory;

    public FoodJournalScreenHandler(@Nullable ScreenHandlerType<?> type, int syncId, FoodJournalView currentView, ServerPlayerEntity player, FoodHistory foodHistory) {
        super(type, syncId);
        int i;
        this.currentView = currentView;
        this.player = player;
        this.clientHasMod = SpiceOfFabric.hasClientMod(player);
        this.foodJournalInventory = this.createFoodJournalInventory(foodHistory, currentView);
        for (int i2 = 0; i2 < 45; ++i2) {
            this.addSlot(new ReadOnlySlot(this.foodJournalInventory, i2, 0, 0));
        }
        this.infoInventory = new SimpleInventory(new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, PREV_STACK, this.createPageIndicatorStack(), NEXT_STACK, this.getViewStack(FoodJournalView.HISTORY, Items.BOOK), this.getViewStack(FoodJournalView.CARROT, Items.GOLD_INGOT), this.getViewStack(FoodJournalView.CARROT_UNEATEN, Items.COPPER_INGOT)});
        this.addSlot(new ReadOnlySlot(this.infoInventory, 0, 0, 0));
        this.addSlot(new ReadOnlySlot(this.infoInventory, 1, 0, 0));
        this.addSlot(new ReadOnlySlot(this.infoInventory, 2, 0, 0));
        this.addSlot(new ClickableSlot(this.infoInventory, 3, 0, 0, this::previousPage));
        this.addSlot(new ReadOnlySlot(this.infoInventory, 4, 0, 0));
        this.addSlot(new ClickableSlot(this.infoInventory, 5, 0, 0, this::nextPage));
        this.addSlot(new ClickableSlot(this.infoInventory, 6, 0, 0, this.getViewCallback(FoodJournalView.HISTORY)));
        this.addSlot(new ClickableSlot(this.infoInventory, 7, 0, 0, this.getViewCallback(FoodJournalView.CARROT)));
        this.addSlot(new ClickableSlot(this.infoInventory, 8, 0, 0, this.getViewCallback(FoodJournalView.CARROT_UNEATEN)));
        PlayerInventory playerInventory = player.getInventory();
        for (i = 9; i < 36; ++i) {
            this.addSlot(new Slot((Inventory)playerInventory, i, 0, 0));
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Inventory)playerInventory, i, 0, 0));
        }
    }

    private PaginatedReadOnlyInventory createFoodJournalInventory(FoodHistory foodHistory, FoodJournalView view) {
        if (view == FoodJournalView.HISTORY) {
            int historySize = foodHistory.getRecentlyEatenCount();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(historySize);
            for (int i = 0; i < historySize; ++i) {
                stacks.add(foodHistory.getStackFromRecentlyEaten(i));
            }
            return new PaginatedReadOnlyInventory(45, stacks);
        }
        if (view == FoodJournalView.CARROT) {
            List<ItemStack> stacks = foodHistory.getUniqueFoodsEaten().stream().map(FoodHistoryEntry::getStack).sorted(Comparator.comparingInt(stack -> {
                FoodComponent foodComponent = stack.getItem().getFoodComponent();
                if (foodComponent == null) {
                    return 0;
                }
                return foodComponent.getHunger();
            })).toList();
            return new PaginatedReadOnlyInventory(45, stacks);
        }
        if (view == FoodJournalView.CARROT_UNEATEN) {
            Set eatenItems = foodHistory.getUniqueFoodsEaten().stream().map(entry -> entry.getStack().getItem()).collect(Collectors.toUnmodifiableSet());
            List<ItemStack> stacks = ((Stream)Registries.ITEM.stream().parallel()).filter(FoodUtils::isFood).filter(item -> !eatenItems.contains(item)).sorted(Comparator.comparingInt(item -> {
                FoodComponent foodComponent = item.getFoodComponent();
                if (foodComponent == null) {
                    return 0;
                }
                return foodComponent.getHunger();
            })).map(ItemStack::new).toList();
            return new PaginatedReadOnlyInventory(45, stacks);
        }
        throw new IllegalStateException("Unrecognized view " + view + " during journal screen creation");
    }

    private ItemStack createPageIndicatorStack() {
        ItemStack stack = new ItemStack((ItemConvertible)PAGE_INDICATOR_ITEM);
        stack.setCustomName((Text)Text.translatable((String)PAGE_INDICATOR_TEXT_KEY, (Object[])new Object[]{this.foodJournalInventory.getPage() + 1, this.foodJournalInventory.getPageCount()}).styled(style -> style.withItalic(Boolean.valueOf(false))));
        return stack;
    }

    private ItemStack getViewStack(FoodJournalView view, Item itemRepresentation) {
        if (this.currentView == view || !view.isAvailable()) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemConvertible)itemRepresentation).setCustomName((Text)(this.clientHasMod ? view.getTranslatableName() : Text.literal((String)view.getLiteralName()).styled(style -> style.withItalic(Boolean.valueOf(false)))));
    }

    private Runnable getViewCallback(FoodJournalView view) {
        if (!view.isAvailable()) {
            return () -> {};
        }
        return () -> this.player.openHandledScreen((NamedScreenHandlerFactory)new Factory(this.player, view));
    }

    private void previousPage() {
        int page = this.foodJournalInventory.getPage();
        if (page > 0) {
            this.foodJournalInventory.setPage(--page);
            this.infoInventory.setStack(4, this.createPageIndicatorStack());
            this.syncState();
        }
    }

    private void nextPage() {
        int page = this.foodJournalInventory.getPage();
        if (page < this.foodJournalInventory.getPageCount() - 1) {
            this.foodJournalInventory.setPage(++page);
            this.infoInventory.setStack(4, this.createPageIndicatorStack());
            this.syncState();
        }
    }

    public ItemStack quickMove(PlayerEntity player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean canUse(PlayerEntity player) {
        return true;
    }

    static {
        PREV_STACK.setCustomName((Text)Text.translatable((String)"createWorld.customize.custom.prev").styled(style -> style.withItalic(Boolean.valueOf(false))));
        NEXT_STACK = new ItemStack((ItemConvertible)Items.FLINT);
        NEXT_STACK.setCustomName((Text)Text.translatable((String)"createWorld.customize.custom.next").styled(style -> style.withItalic(Boolean.valueOf(false))));
    }

    public static class Factory
    implements NamedScreenHandlerFactory {
        private final ServerPlayerEntity player;
        private final FoodJournalView view;

        public Factory(ServerPlayerEntity player, FoodJournalView view) {
            this.player = player;
            this.view = view;
        }

        public Text getDisplayName() {
            if (SpiceOfFabric.hasClientMod(this.player)) {
                return this.view.getTranslatableName();
            }
            return Text.literal((String)this.view.getLiteralName());
        }

        @Nullable
        public ScreenHandler createMenu(int syncId, PlayerInventory inv, PlayerEntity player) {
            return new FoodJournalScreenHandler(ScreenHandlerType.GENERIC_9X6, syncId, this.view, this.player, ((IHungerManager)player.getHungerManager()).spiceOfFabric_getFoodHistory());
        }
    }
}

