/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.config.SOFConfig;
import java.util.Locale;
import net.minecraft.text.Text;

public enum FoodJournalView {
    HISTORY("Least to most recently eaten"),
    CARROT("All unique foods eaten so far"),
    CARROT_UNEATEN("Unique foods that have not been eaten yet");

    private final Text translatableName = Text.translatable((String)("spiceoffabric.journal.screen.view." + this.name().toLowerCase(Locale.ROOT))).styled(style -> style.withItalic(Boolean.valueOf(false)));
    private final String literalName;

    public static FoodJournalView getDefault() {
        if (HISTORY.isAvailable()) {
            return HISTORY;
        }
        if (CARROT.isAvailable()) {
            return CARROT;
        }
        return null;
    }

    private FoodJournalView(String literalName) {
        this.literalName = literalName;
    }

    public Text getTranslatableName() {
        return this.translatableName;
    }

    public String getLiteralName() {
        return this.literalName;
    }

    public boolean isAvailable() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HISTORY -> {
                if (SOFConfig.food.historyLength > 0) {
                    yield true;
                }
                yield false;
            }
            case CARROT -> SOFConfig.carrot.enable;
            case CARROT_UNEATEN -> SOFConfig.carrot.enable && SOFConfig.carrot.uneatenInJournal;
        };
    }
}

