/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.item.FoodContainerItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventories;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.util.collection.DefaultedList;

public class ItemStackInventory
implements Inventory {
    private final ItemStack containerStack;
    private final String nbtKey;
    private final int size;
    private final DefaultedList<ItemStack> stacks;

    public ItemStackInventory(ItemStack containerStack, String nbtKey, int size) {
        this.nbtKey = nbtKey;
        this.size = size;
        this.containerStack = containerStack;
        this.stacks = DefaultedList.ofSize((int)size, (Object)ItemStack.EMPTY);
        Inventories.readNbt((NbtCompound)containerStack.getOrCreateSubNbt(nbtKey), this.stacks);
    }

    public DefaultedList<ItemStack> getContainedStacks() {
        return this.stacks;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStack(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack removeStack(int slot, int amount) {
        ItemStack split = ((ItemStack)this.stacks.get(slot)).split(amount);
        this.markDirty();
        return split;
    }

    public ItemStack removeStack(int slot) {
        ItemStack stack = (ItemStack)this.stacks.get(slot);
        this.stacks.set(slot, (Object)ItemStack.EMPTY);
        this.markDirty();
        return stack;
    }

    public boolean isValid(int slot, ItemStack stack) {
        return stack.isFood() && !(stack.getItem() instanceof FoodContainerItem);
    }

    public void setStack(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        this.markDirty();
    }

    public void markDirty() {
        Inventories.writeNbt((NbtCompound)this.containerStack.getOrCreateSubNbt(this.nbtKey), this.stacks);
    }

    public boolean canPlayerUse(PlayerEntity player) {
        return true;
    }

    public void clear() {
        this.stacks.clear();
    }
}

