/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.container;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;

public class PaginatedReadOnlyInventory
implements Inventory {
    private final List<ItemStack> stacks;
    private final int viewSize;
    private int page;

    public PaginatedReadOnlyInventory(int viewSize, List<ItemStack> stacks) {
        this.viewSize = viewSize;
        this.stacks = stacks;
    }

    public int getPageCount() {
        int count = (this.stacks.size() - 1) / this.size() + 1;
        if (count <= 0) {
            return 1;
        }
        return count;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int size() {
        return this.viewSize;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getStack(int slot) {
        int index = this.page * this.size() + slot;
        if (index < 0 || index >= this.stacks.size()) {
            return ItemStack.EMPTY;
        }
        return this.stacks.get(index);
    }

    public ItemStack removeStack(int slot, int amount) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeStack(int slot) {
        return ItemStack.EMPTY;
    }

    public void setStack(int slot, ItemStack stack) {
    }

    public void markDirty() {
    }

    public boolean canPlayerUse(PlayerEntity player) {
        return true;
    }

    public void clear() {
    }
}

