/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.foodhistory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.queue.ArrayFixedLengthIntFIFOQueue;
import de.siphalor.spiceoffabric.util.queue.FixedLengthIntFIFOQueueWithStats;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.attribute.EntityAttributeInstance;
import net.minecraft.entity.attribute.EntityAttributes;
import net.minecraft.entity.player.HungerManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtInt;
import net.minecraft.nbt.NbtList;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;

public class FoodHistory {
    protected static final String DICTIONARY_NBT_KEY = "dictionary";
    protected static final String RECENT_HISTORY_NBT_KEY = "history";
    protected static final String CARROT_HISTORY_NBT_KEY = "carrotHistory";
    protected final BiMap<Integer, FoodHistoryEntry> dictionary = HashBiMap.create();
    protected int nextId = 0;
    protected final FixedLengthIntFIFOQueueWithStats recentlyEaten;
    protected final Set<FoodHistoryEntry> uniqueFoodsEaten;

    public static FoodHistory get(PlayerEntity player) {
        if (player == null) {
            return null;
        }
        HungerManager hungerManager = player.getHungerManager();
        if (!(hungerManager instanceof IHungerManager)) {
            return null;
        }
        return ((IHungerManager)hungerManager).spiceOfFabric_getFoodHistory();
    }

    public FoodHistory() {
        this.recentlyEaten = new FixedLengthIntFIFOQueueWithStats(new ArrayFixedLengthIntFIFOQueue(SOFConfig.food.historyLength));
        this.uniqueFoodsEaten = new HashSet<FoodHistoryEntry>();
    }

    public void reset() {
        this.resetHistory();
        this.resetUniqueFoodsEaten();
    }

    public void resetHistory() {
        this.dictionary.clear();
        this.nextId = 0;
        this.recentlyEaten.clear();
    }

    public Set<FoodHistoryEntry> getUniqueFoodsEaten() {
        return this.uniqueFoodsEaten;
    }

    public void resetUniqueFoodsEaten() {
        this.uniqueFoodsEaten.clear();
    }

    public void write(PacketByteBuf buffer) {
        buffer.writeVarInt(this.dictionary.size());
        for (Map.Entry entry : this.dictionary.entrySet()) {
            buffer.writeVarInt(((Integer)entry.getKey()).intValue());
            ((FoodHistoryEntry)entry.getValue()).write(buffer);
        }
        buffer.writeVarInt(this.recentlyEaten.size());
        IntIterator intIterator = this.recentlyEaten.iterator();
        while (intIterator.hasNext()) {
            int integer = (Integer)intIterator.next();
            buffer.writeVarInt(integer);
        }
        if (SOFConfig.carrot.enable) {
            buffer.writeBoolean(true);
            buffer.writeVarInt(this.uniqueFoodsEaten.size());
            for (FoodHistoryEntry entry : this.uniqueFoodsEaten) {
                entry.write(buffer);
            }
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void read(PacketByteBuf buffer) {
        int i;
        this.dictionary.clear();
        this.recentlyEaten.clear();
        this.recentlyEaten.setLength(SOFConfig.food.historyLength);
        int l = buffer.readVarInt();
        for (i = 0; i < l; ++i) {
            this.dictionary.put((Object)buffer.readVarInt(), (Object)FoodHistoryEntry.from(buffer));
        }
        l = buffer.readVarInt();
        for (i = 0; i < l; ++i) {
            this.recentlyEaten.forceEnqueue(buffer.readVarInt());
        }
        this.uniqueFoodsEaten.clear();
        if (buffer.readBoolean()) {
            int length = buffer.readVarInt();
            for (i = 0; i < length; ++i) {
                this.uniqueFoodsEaten.add(FoodHistoryEntry.from(buffer));
            }
        }
    }

    public NbtCompound write(NbtCompound compoundTag) {
        Map.Entry entry2;
        this.defragmentDictionary();
        NbtList list = new NbtList();
        for (Map.Entry entry2 : this.dictionary.entrySet()) {
            list.add(((Integer)entry2.getKey()).intValue(), (NbtElement)((FoodHistoryEntry)entry2.getValue()).write(new NbtCompound()));
        }
        compoundTag.put(DICTIONARY_NBT_KEY, (NbtElement)list);
        NbtList historyList = new NbtList();
        entry2 = this.recentlyEaten.iterator();
        while (entry2.hasNext()) {
            Integer id = (Integer)entry2.next();
            historyList.add((Object)NbtInt.of((int)id));
        }
        compoundTag.put(RECENT_HISTORY_NBT_KEY, (NbtElement)historyList);
        NbtList carrotHistoryList = new NbtList();
        for (FoodHistoryEntry entry3 : this.uniqueFoodsEaten) {
            carrotHistoryList.add((Object)entry3.write(new NbtCompound()));
        }
        compoundTag.put(CARROT_HISTORY_NBT_KEY, (NbtElement)carrotHistoryList);
        return compoundTag;
    }

    public static FoodHistory read(NbtCompound compoundTag) {
        FoodHistory foodHistory = new FoodHistory();
        if (compoundTag.contains(DICTIONARY_NBT_KEY, 9)) {
            NbtList nbtDictionary = compoundTag.getList(DICTIONARY_NBT_KEY, 10);
            for (int i = 0; i < nbtDictionary.size(); ++i) {
                FoodHistoryEntry entry = new FoodHistoryEntry().read((NbtCompound)nbtDictionary.get(i));
                if (entry == null) continue;
                foodHistory.dictionary.put((Object)i, (Object)entry);
            }
        }
        foodHistory.nextId = foodHistory.dictionary.size();
        if (compoundTag.contains(RECENT_HISTORY_NBT_KEY, 9)) {
            NbtList nbtRecentHistory = compoundTag.getList(RECENT_HISTORY_NBT_KEY, 3);
            for (NbtElement tag : nbtRecentHistory) {
                foodHistory.recentlyEaten.forceEnqueue(((NbtInt)tag).intValue());
            }
        }
        if (compoundTag.contains(CARROT_HISTORY_NBT_KEY, 9)) {
            NbtList nbtCarrotHistory = compoundTag.getList(CARROT_HISTORY_NBT_KEY, 10);
            for (NbtElement tag : nbtCarrotHistory) {
                NbtCompound carrotEntry;
                FoodHistoryEntry entry;
                if (!(tag instanceof NbtCompound) || (entry = new FoodHistoryEntry().read(carrotEntry = (NbtCompound)tag)) == null) continue;
                foodHistory.uniqueFoodsEaten.add(entry);
            }
        }
        return foodHistory;
    }

    public void defragmentDictionary() {
        Int2IntArrayMap oldToNewMap = new Int2IntArrayMap();
        int i = 0;
        for (Integer id : this.dictionary.keySet()) {
            oldToNewMap.put(id.intValue(), i);
            ++i;
        }
        this.nextId = i;
        int historySize = this.recentlyEaten.size();
        for (int j = 0; j < historySize; ++j) {
            this.recentlyEaten.enqueue(oldToNewMap.get(this.recentlyEaten.dequeue()));
        }
        HashBiMap newDictionary = HashBiMap.create();
        for (Map.Entry entry : this.dictionary.entrySet()) {
            newDictionary.put((Object)oldToNewMap.get(((Integer)entry.getKey()).intValue()), (Object)((FoodHistoryEntry)entry.getValue()));
        }
        this.dictionary.clear();
        this.dictionary.putAll((Map)newDictionary);
    }

    public int getTimesRecentlyEaten(ItemStack stack) {
        Integer id = (Integer)this.dictionary.inverse().get((Object)FoodHistoryEntry.fromItemStack(stack));
        if (id == null) {
            return 0;
        }
        return this.recentlyEaten.getStats().getOrDefault(id.intValue(), 0);
    }

    public int getFoodCountSinceLastEaten(ItemStack stack) {
        Integer id = (Integer)this.dictionary.inverse().get((Object)FoodHistoryEntry.fromItemStack(stack));
        if (id == null) {
            return -1;
        }
        IntIterator iterator = this.recentlyEaten.iterator();
        int foundI = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            ++foundI;
            if (iterator.nextInt() != id.intValue()) continue;
            foundI = 0;
        }
        return foundI;
    }

    public void addFood(ItemStack stack, ServerPlayerEntity player) {
        FoodHistoryEntry entry = FoodHistoryEntry.fromItemStack(stack);
        if (SpiceOfFabric.hasClientMod(player)) {
            SOFCommonNetworking.sendAddFoodPacket(player, entry);
        }
        this.addFood(entry);
    }

    public void addFood(FoodHistoryEntry entry) {
        int id;
        Integer boxedId = (Integer)this.dictionary.inverse().get((Object)entry);
        if (boxedId == null) {
            id = this.nextId++;
            this.dictionary.put((Object)id, (Object)entry);
        } else {
            id = boxedId;
        }
        if (this.recentlyEaten.getLength() != SOFConfig.food.historyLength) {
            this.recentlyEaten.setLength(SOFConfig.food.historyLength);
        }
        this.recentlyEaten.forceEnqueue(id);
        if (SOFConfig.carrot.enable) {
            this.uniqueFoodsEaten.add(entry);
        }
    }

    public int getRecentlyEatenCount() {
        return this.recentlyEaten.size();
    }

    public ItemStack getStackFromRecentlyEaten(int index) {
        if (index < 0 || index >= this.recentlyEaten.size()) {
            return null;
        }
        return ((FoodHistoryEntry)this.dictionary.get((Object)this.recentlyEaten.get(index))).getStack();
    }

    public boolean isInUniqueEaten(ItemStack stack) {
        FoodHistoryEntry entry = FoodHistoryEntry.fromItemStack(stack);
        return this.uniqueFoodsEaten.contains(entry);
    }

    public int getCarrotHealthOffset(PlayerEntity player) {
        EntityAttributeInstance maxHealthAttr = player.getAttributeInstance(EntityAttributes.GENERIC_MAX_HEALTH);
        SOFConfig.setHealthFormulaExpressionValues(this.uniqueFoodsEaten.size(), (int)maxHealthAttr.getBaseValue());
        int newMaxHealth = MathHelper.floor((double)SOFConfig.healthFormulaExpression.evaluate());
        if (SOFConfig.carrot.maxHealth > 0) {
            newMaxHealth = MathHelper.clamp((int)newMaxHealth, (int)1, (int)SOFConfig.carrot.maxHealth);
        }
        return newMaxHealth - (int)maxHealthAttr.getBaseValue();
    }

    public int getCarrotMaxHealth(PlayerEntity player) {
        EntityAttributeInstance maxHealthAttr = player.getAttributeInstance(EntityAttributes.GENERIC_MAX_HEALTH);
        SOFConfig.setHealthFormulaExpressionValues(this.uniqueFoodsEaten.size(), (int)maxHealthAttr.getBaseValue());
        return MathHelper.floor((double)SOFConfig.healthFormulaExpression.evaluate());
    }
}

