/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.foodhistory;

import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.registry.Registries;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;

public class FoodHistoryEntry {
    private int itemId = 0;
    private NbtCompound data = new NbtCompound();

    public void write(PacketByteBuf buffer) {
        buffer.writeVarInt(this.itemId);
    }

    public MutableText getStackName() {
        return Text.translatable((String)this.getStack().getTranslationKey());
    }

    public ItemStack getStack() {
        ItemStack stack = new ItemStack((ItemConvertible)Registries.ITEM.get(this.itemId));
        stack.setNbt(this.data);
        return stack;
    }

    public String getItemStackSerialization() {
        return "{id:\"" + Registries.ITEM.getId((Object)((Item)Registries.ITEM.get(this.itemId))) + "\",tag:" + this.data.asString() + ",Count:1}";
    }

    public static FoodHistoryEntry from(PacketByteBuf buffer) {
        FoodHistoryEntry entry = new FoodHistoryEntry();
        entry.itemId = buffer.readVarInt();
        return entry;
    }

    public NbtCompound write(NbtCompound compoundTag) {
        compoundTag.putString("item", Registries.ITEM.getId((Object)((Item)Registries.ITEM.get(this.itemId))).toString());
        compoundTag.put("data", (NbtElement)this.data);
        return compoundTag;
    }

    public FoodHistoryEntry read(NbtCompound compoundTag) {
        Optional item = Registries.ITEM.getOrEmpty(Identifier.tryParse((String)compoundTag.getString("item")));
        if (item.isEmpty()) {
            return null;
        }
        this.itemId = Registries.ITEM.getRawId((Object)((Item)item.get()));
        this.data = compoundTag.getCompound("data");
        return this;
    }

    public static FoodHistoryEntry fromItemStack(ItemStack stack) {
        FoodHistoryEntry entry = new FoodHistoryEntry();
        entry.itemId = Registries.ITEM.getRawId((Object)stack.getItem());
        return entry;
    }

    public boolean equals(Object other) {
        if (other instanceof FoodHistoryEntry) {
            FoodHistoryEntry otherEntry = (FoodHistoryEntry)other;
            return otherEntry.itemId == this.itemId && otherEntry.data.equals((Object)this.data);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return Integer.valueOf(this.itemId).hashCode();
    }
}

