/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.item;

import com.mojang.datafixers.util.Pair;
import de.siphalor.capsaicin.api.food.CamoFoodContext;
import de.siphalor.capsaicin.api.food.CamoFoodItem;
import de.siphalor.capsaicin.api.food.DynamicFoodPropertiesAccess;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.container.FoodContainerScreenHandler;
import de.siphalor.spiceoffabric.container.ItemStackInventory;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import de.siphalor.spiceoffabric.util.IndexedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.item.TooltipContext;
import net.minecraft.entity.ItemEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.FoodComponent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUsage;
import net.minecraft.screen.NamedScreenHandlerFactory;
import net.minecraft.screen.ScreenHandler;
import net.minecraft.screen.ScreenHandlerListener;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.screen.slot.Slot;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Style;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;
import net.minecraft.util.Hand;
import net.minecraft.util.TypedActionResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoodContainerItem
extends Item
implements CamoFoodItem {
    private static final String INVENTORY_NBT_KEY = "inventory";
    private static final Style LORE_STYLE = Style.EMPTY.withColor(Formatting.GRAY).withItalic(Boolean.valueOf(false));
    private static final Text LORE_EMPTY = Text.translatable((String)"spiceoffabric.food_container.lore.empty").setStyle(LORE_STYLE);
    private static final String LORE_GENERAL_KEY = "spiceoffabric.food_container.lore.general";
    private static final IndexedValue<ItemStack> NO_STACK = new IndexedValue<ItemStack>(-1, ItemStack.EMPTY);
    private final ScreenHandlerType<?> screenHandlerType;
    private final int size;

    public FoodContainerItem(Item.Settings settings, int size, ScreenHandlerType<?> screenHandlerType) {
        super(settings);
        this.screenHandlerType = screenHandlerType;
        this.size = size;
    }

    public ScreenHandlerType<?> getScreenHandlerType() {
        return this.screenHandlerType;
    }

    public int getSize() {
        return this.size;
    }

    public ItemStack getNextFoodStack(ItemStack stack, PlayerEntity player) {
        return this.getNextFoodStack(this.getInventory(stack), player).value();
    }

    private IndexedValue<ItemStack> getNextFoodStack(ItemStackInventory inventory, PlayerEntity player) {
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return NO_STACK;
        }
        ArrayList<IndexedValue<Pair<ItemStack, FoodComponent>>> filteredInv = new ArrayList<IndexedValue<Pair<ItemStack, FoodComponent>>>(inventory.size());
        DynamicFoodPropertiesAccess foodPropertiesAccess = DynamicFoodPropertiesAccess.create();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getStack(i);
            if (stack.isEmpty()) continue;
            FoodComponent foodComponent = foodPropertiesAccess.withStack(stack).getModifiedFoodComponent();
            if (foodComponent == null) {
                SpiceOfFabric.LOGGER.warn("Non-food stack " + stack + " found in food container " + this);
                continue;
            }
            if (stack.isEmpty() || !player.canConsume(foodComponent.isAlwaysEdible())) continue;
            filteredInv.add(new IndexedValue<Pair>(i, Pair.of((Object)stack, (Object)foodComponent)));
        }
        if (filteredInv.isEmpty()) {
            return NO_STACK;
        }
        int requiredFood = 20 - player.getHungerManager().getFoodLevel();
        return this.findMostAppropriateFood(filteredInv, requiredFood);
    }

    private IndexedValue<ItemStack> findMostAppropriateFood(List<IndexedValue<Pair<ItemStack, FoodComponent>>> foods, int requiredFood) {
        IndexedValue<ItemStack> bestStack = NO_STACK;
        int bestDelta = Integer.MAX_VALUE;
        int bestConsumeTime = Integer.MAX_VALUE;
        for (IndexedValue<Pair<ItemStack, FoodComponent>> value : foods) {
            ItemStack stack = (ItemStack)value.value().getFirst();
            int delta = requiredFood - ((FoodComponent)value.value().getSecond()).getHunger();
            int consumeTime = stack.getMaxUseTime();
            if (delta <= 0) {
                if (delta <= bestDelta && bestDelta <= 0 && (delta != bestDelta || consumeTime >= bestConsumeTime)) continue;
                bestDelta = delta;
                bestConsumeTime = consumeTime;
                bestStack = new IndexedValue<ItemStack>(value.index(), stack);
                continue;
            }
            if (bestDelta <= 0 || delta >= bestDelta && (delta != bestDelta || consumeTime >= bestConsumeTime)) continue;
            bestDelta = delta;
            bestConsumeTime = consumeTime;
            bestStack = new IndexedValue<ItemStack>(value.index(), stack);
        }
        return bestStack;
    }

    public boolean isInventoryEmpty(ItemStack stack) {
        return this.getInventory(stack).isEmpty();
    }

    public ItemStackInventory getInventory(ItemStack stack) {
        return new ItemStackInventory(stack, INVENTORY_NBT_KEY, this.size);
    }

    public void onItemEntityDestroyed(ItemEntity entity) {
        ItemStackInventory inventory = this.getInventory(entity.getStack());
        ItemUsage.spawnItemContents((ItemEntity)entity, (Stream)inventory.getContainedStacks().stream());
    }

    public void appendTooltip(ItemStack stack, @Nullable World world, List<Text> tooltip, TooltipContext context) {
        ItemStackInventory inventory = this.getInventory(stack);
        if (inventory.isEmpty()) {
            tooltip.add(LORE_EMPTY);
        } else {
            int count = 0;
            int filled = 0;
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack invStack = inventory.getStack(i);
                if (invStack.isEmpty()) continue;
                count += invStack.getCount();
                ++filled;
            }
            tooltip.add((Text)Text.translatable((String)LORE_GENERAL_KEY, (Object[])new Object[]{filled, this.size, count}).setStyle(LORE_STYLE));
        }
    }

    public boolean isFood() {
        return true;
    }

    public TypedActionResult<ItemStack> use(World world, PlayerEntity user, Hand hand) {
        ItemStack stackInHand = user.getStackInHand(hand);
        ItemStack nextFoodItem = this.getNextFoodStack(stackInHand, user);
        if (nextFoodItem.isEmpty()) {
            ServerPlayerEntity player;
            long currentTime = System.currentTimeMillis();
            if (user instanceof ServerPlayerEntity && this.checkLastEatTime(player = (ServerPlayerEntity)user, currentTime)) {
                this.updateLastEatTime(player, currentTime);
                this.openScreen(stackInHand, user, hand == Hand.MAIN_HAND ? user.getInventory().selectedSlot : 40);
                return TypedActionResult.success((Object)stackInHand);
            }
        } else if (nextFoodItem.isFood()) {
            FoodComponent foodComponent = nextFoodItem.getItem().getFoodComponent();
            if (foodComponent != null && user.canConsume(foodComponent.isAlwaysEdible())) {
                user.setCurrentHand(hand);
                return TypedActionResult.consume((Object)stackInHand);
            }
            return TypedActionResult.fail((Object)stackInHand);
        }
        return TypedActionResult.pass((Object)stackInHand);
    }

    public void onStoppedUsing(ItemStack stack, World world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClient && user instanceof ServerPlayerEntity) {
            long currentTime;
            ServerPlayerEntity player = (ServerPlayerEntity)user;
            int maxUseTime = this.getMaxUseTime(stack);
            if (maxUseTime - remainingUseTicks <= 5 && this.checkLastEatTime(player, currentTime = System.currentTimeMillis())) {
                this.updateLastEatTime(player, currentTime);
                PlayerInventory inv = player.getInventory();
                for (int i = 0; i < inv.size(); ++i) {
                    if (inv.getStack(i) != stack) continue;
                    this.openScreen(stack, (PlayerEntity)player, i);
                    return;
                }
            }
        }
        super.onStoppedUsing(stack, world, user, remainingUseTicks);
    }

    public boolean checkLastEatTime(ServerPlayerEntity user, long currentTime) {
        long lastEatTime = ((IServerPlayerEntity)user).spiceOfFabric_getLastContainerEatTime();
        return currentTime - lastEatTime >= 1000L;
    }

    public void updateLastEatTime(ServerPlayerEntity user, long currentTime) {
        ((IServerPlayerEntity)user).spiceOfFabric_setLastContainerEatTime(currentTime);
    }

    public ItemStack finishUsing(ItemStack stack, World world, LivingEntity user) {
        ItemStack newStack;
        if (!(user instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)user;
        ItemStackInventory inventory = this.getInventory(stack);
        IndexedValue<ItemStack> foodStack = this.getNextFoodStack(inventory, player);
        if (foodStack.value().isEmpty()) {
            return stack;
        }
        if (player instanceof ServerPlayerEntity) {
            ((IServerPlayerEntity)player).spiceOfFabric_setLastContainerEatTime(System.currentTimeMillis());
        }
        if ((newStack = foodStack.value().finishUsing(world, user)) != foodStack.value()) {
            if (inventory.isValid(foodStack.index(), newStack)) {
                inventory.setStack(foodStack.index(), newStack);
            } else {
                player.getInventory().offerOrDrop(newStack);
                inventory.removeStack(foodStack.index());
            }
        } else {
            inventory.markDirty();
        }
        return stack;
    }

    protected void openScreen(final ItemStack stack, final PlayerEntity user, final int invIndex) {
        user.clearActiveItem();
        user.openHandledScreen((NamedScreenHandlerFactory)new FoodContainerScreenHandler.Factory(this, stack));
        user.currentScreenHandler.addListener(new ScreenHandlerListener(){

            public void onSlotUpdate(ScreenHandler handler, int updateSlotId, ItemStack updateStack) {
                Slot updateSlot = handler.getSlot(updateSlotId);
                if (!(user instanceof ServerPlayerEntity)) {
                    return;
                }
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)user;
                if (updateSlot.getIndex() == invIndex && updateSlot.inventory == user.getInventory()) {
                    if (updateStack.isEmpty() || !ItemStack.areEqual((ItemStack)updateStack, (ItemStack)stack)) {
                        FoodContainerItem.closeScreen(serverPlayer);
                    }
                } else if (ItemStack.areEqual((ItemStack)updateStack, (ItemStack)stack)) {
                    FoodContainerItem.closeScreen(serverPlayer);
                }
            }

            public void onPropertyUpdate(ScreenHandler handler, int property, int value) {
            }
        });
    }

    private static void closeScreen(ServerPlayerEntity player) {
        player.closeHandledScreen();
    }

    @Nullable
    public ItemStack getCamoFoodStack(@NotNull ItemStack stack, CamoFoodContext context) {
        LivingEntity livingEntity = context.user();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            return this.getNextFoodStack(stack, player);
        }
        return stack;
    }
}

