/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.mixin;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.entity.attribute.EntityAttributeInstance;
import net.minecraft.entity.attribute.EntityAttributeModifier;
import net.minecraft.entity.attribute.EntityAttributes;
import net.minecraft.entity.player.HungerManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtInt;
import net.minecraft.server.network.ServerPlayerEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HungerManager.class})
public abstract class MixinHungerManager
implements IHungerManager {
    @Shadow
    private float saturationLevel;
    @Unique
    @Nullable
    protected ServerPlayerEntity player = null;
    @Unique
    protected FoodHistory foodHistory = new FoodHistory();

    @Shadow
    public abstract void add(int var1, float var2);

    @Override
    public void spiceOfFabric_setPlayer(ServerPlayerEntity serverPlayerEntity) {
        this.player = serverPlayerEntity;
    }

    @Override
    public void spiceOfFabric_clearHistory() {
        this.foodHistory.reset();
    }

    @Override
    public void spiceOfFabric_setSaturationLevel(float level) {
        this.saturationLevel = level;
    }

    @Override
    public FoodHistory spiceOfFabric_getFoodHistory() {
        return this.foodHistory;
    }

    @Override
    public void spiceOfFabric_setFoodHistory(FoodHistory foodHistory) {
        this.foodHistory = foodHistory;
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    public void onDeserialize(NbtCompound data, CallbackInfo callbackInfo) {
        if (data.contains("spiceOfFabric_history", 10)) {
            this.foodHistory = FoodHistory.read(data.getCompound("spiceOfFabric_history"));
            if (this.player != null && SOFConfig.carrot.enable) {
                EntityAttributeInstance healthAttribute = this.player.getAttributeInstance(EntityAttributes.GENERIC_MAX_HEALTH);
                if (healthAttribute == null) {
                    SpiceOfFabric.LOGGER.error("Players must have a maximum health!");
                    return;
                }
                if (data.contains("spiceOfFabric_version")) {
                    EntityAttributeModifier modifier = healthAttribute.getModifier(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
                    if (modifier == null) {
                        SpiceOfFabric.updateMaxHealth(this.player, false, false);
                    }
                } else {
                    healthAttribute.removeModifier(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
                    healthAttribute.setBaseValue(20.0);
                    healthAttribute.addPersistentModifier(new EntityAttributeModifier(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID, "spiceoffabric", (double)this.foodHistory.getCarrotHealthOffset((PlayerEntity)this.player), EntityAttributeModifier.Operation.ADDITION));
                }
            }
        }
        if (this.player != null) {
            ((IServerPlayerEntity)this.player).spiceOfFabric_scheduleFoodHistorySync();
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void onSerialize(NbtCompound data, CallbackInfo callbackInfo) {
        data.put("spiceOfFabric_history", (NbtElement)this.foodHistory.write(new NbtCompound()));
        data.put("spiceOfFabric_version", (NbtElement)NbtInt.of((int)1));
    }
}

