/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.command.argument.EntityAnchorArgumentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.packet.c2s.common.SyncedClientOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayerEntity.class}, priority=1100)
public abstract class MixinServerPlayerEntity
extends PlayerEntity
implements IServerPlayerEntity {
    @Unique
    protected boolean foodHistorySync = false;
    @Unique
    protected long lastContainerEatTime;

    @Shadow
    public abstract void lookAt(EntityAnchorArgumentType.EntityAnchor var1, Vec3d var2);

    protected MixinServerPlayerEntity(World world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public void spiceOfFabric_scheduleFoodHistorySync() {
        this.foodHistorySync = true;
    }

    @Override
    public boolean spiceOfFabric_foodHistorySync() {
        boolean result = this.foodHistorySync;
        this.foodHistorySync = false;
        return result;
    }

    @Override
    public long spiceOfFabric_getLastContainerEatTime() {
        return this.lastContainerEatTime;
    }

    @Override
    public void spiceOfFabric_setLastContainerEatTime(long time) {
        this.lastContainerEatTime = time;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstruct(MinecraftServer server, ServerWorld world, GameProfile profile, SyncedClientOptions clientOptions, CallbackInfo ci) {
        ((IHungerManager)this.hungerManager).spiceOfFabric_setPlayer((ServerPlayerEntity)this);
        SpiceOfFabric.updateMaxHealth((ServerPlayerEntity)this, false, false);
        this.setHealth(this.getMaxHealth());
    }

    @Inject(method={"copyFrom"}, at={@At(value="RETURN")})
    public void onPlayerCopied(ServerPlayerEntity reference, boolean exact, CallbackInfo callbackInfo) {
        if (exact) {
            ((IHungerManager)this.hungerManager).spiceOfFabric_setPlayer((ServerPlayerEntity)this);
            SpiceOfFabric.updateMaxHealth((ServerPlayerEntity)this, false, false);
            this.setHealth(reference.getHealth());
        } else {
            Pair<Double, Double> respawnHunger = SOFConfig.getRespawnHunger(reference.getHungerManager().getFoodLevel(), reference.getHungerManager().getSaturationLevel());
            this.hungerManager.setFoodLevel((int)Math.max((Double)respawnHunger.getFirst(), (double)reference.getHungerManager().getFoodLevel()));
            ((IHungerManager)this.hungerManager).spiceOfFabric_setSaturationLevel((float)((Double)respawnHunger.getSecond()).doubleValue());
            FoodHistory foodHistory = ((IHungerManager)reference.getHungerManager()).spiceOfFabric_getFoodHistory();
            if (SOFConfig.respawn.resetHistory) {
                foodHistory.resetHistory();
            }
            if (SOFConfig.carrot.enable && SOFConfig.respawn.resetCarrotMode) {
                foodHistory.resetUniqueFoodsEaten();
            }
            ((IHungerManager)this.hungerManager).spiceOfFabric_setFoodHistory(foodHistory);
            SOFCommonNetworking.syncFoodHistory((ServerPlayerEntity)this);
            SpiceOfFabric.updateMaxHealth((ServerPlayerEntity)this, false, false);
            this.setHealth(this.getMaxHealth());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void afterReadCustomDataFromNbt(NbtCompound nbt, CallbackInfo ci) {
        SpiceOfFabric.updateMaxHealth((ServerPlayerEntity)this, false, false);
        if (nbt.contains("Health", 99)) {
            this.setHealth(nbt.getFloat("Health"));
        }
    }
}

