/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.networking;

import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.util.IHungerManager;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;

public class SOFCommonNetworking {
    protected static final Identifier SYNC_FOOD_HISTORY_S2C_PACKET = new Identifier("spiceoffabric", "sync_food_history");
    protected static final Identifier ADD_FOOD_S2C_PACKET = new Identifier("spiceoffabric", "add_food");
    protected static final Identifier CLEAR_FOODS_S2C_PACKET = new Identifier("spiceoffabric", "clear_foods");

    SOFCommonNetworking() {
    }

    public static void init() {
        S2CPlayChannelEvents.REGISTER.register((handler, sender, server, channels) -> {
            if (channels.contains(SYNC_FOOD_HISTORY_S2C_PACKET)) {
                SOFCommonNetworking.syncFoodHistory(handler.player);
            }
        });
    }

    public static boolean hasClientMod(ServerPlayerEntity player) {
        if (player == null) {
            return false;
        }
        return ServerPlayNetworking.canSend((ServerPlayerEntity)player, (Identifier)SYNC_FOOD_HISTORY_S2C_PACKET);
    }

    public static void syncFoodHistory(ServerPlayerEntity player) {
        if (!ServerPlayNetworking.canSend((ServerPlayerEntity)player, (Identifier)SYNC_FOOD_HISTORY_S2C_PACKET)) {
            return;
        }
        PacketByteBuf buffer = new PacketByteBuf(Unpooled.buffer());
        ((IHungerManager)player.getHungerManager()).spiceOfFabric_getFoodHistory().write(buffer);
        ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)SYNC_FOOD_HISTORY_S2C_PACKET, (PacketByteBuf)buffer);
    }

    public static void sendAddFoodPacket(ServerPlayerEntity player, FoodHistoryEntry foodHistoryEntry) {
        if (!ServerPlayNetworking.canSend((ServerPlayerEntity)player, (Identifier)ADD_FOOD_S2C_PACKET)) {
            return;
        }
        PacketByteBuf buffer = new PacketByteBuf(Unpooled.buffer());
        foodHistoryEntry.write(buffer);
        ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)ADD_FOOD_S2C_PACKET, (PacketByteBuf)buffer);
    }

    public static void sendClearFoodsPacket(ServerPlayerEntity player) {
        if (!ServerPlayNetworking.canSend((ServerPlayerEntity)player, (Identifier)CLEAR_FOODS_S2C_PACKET)) {
            return;
        }
        ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)CLEAR_FOODS_S2C_PACKET, (PacketByteBuf)new PacketByteBuf(Unpooled.buffer()));
    }
}

