/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.polymer;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.polymer.PolymerFoodContainerItem;
import de.siphalor.spiceoffabric.util.FoodUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FoodComponent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemGroups;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.screen.ScreenHandlerType;
import net.minecraft.util.Identifier;

public class SOFPolymer {
    private static final FoodComponent EMPTY_FOOD_COMPONENT = new FoodComponent.Builder().build();

    private SOFPolymer() {
    }

    public static void init() {
        PolymerItemUtils.ITEM_CHECK.register(ItemStack::isFood);
        PolymerItemUtils.ITEM_MODIFICATION_EVENT.register((original, client, player) -> {
            if (!SpiceOfFabric.hasClientMod(player)) {
                FoodUtils.appendServerTooltips((PlayerEntity)player, client);
            }
            return client;
        });
        PolymerResourcePackUtils.addModAssets((String)"spiceoffabric");
        if (SOFConfig.items.enablePaperBag) {
            SOFPolymer.registerFoodContainer("paper_bag", Items.PAPER, Items.POTATO, 5, ScreenHandlerType.HOPPER);
        }
        if (SOFConfig.items.enableLunchBox) {
            SOFPolymer.registerFoodContainer("lunch_box", Items.DARK_OAK_BOAT, Items.COOKIE, 9, ScreenHandlerType.GENERIC_3X3);
        }
        if (SOFConfig.items.enablePicnicBasket) {
            SOFPolymer.registerFoodContainer("picnic_basket", Items.OAK_BOAT, Items.BREAD, 9, ScreenHandlerType.GENERIC_3X3);
        }
    }

    public static void registerFoodContainer(String idPath, Item emptyItem, Item filledItem, int slots, ScreenHandlerType<?> screenHandlerType) {
        Identifier id = new Identifier("spiceoffabric", idPath);
        PolymerModelData emptyModelData = PolymerResourcePackUtils.requestModel((Item)emptyItem, (Identifier)new Identifier(id.getNamespace(), "item/" + id.getPath() + "_empty"));
        PolymerModelData filledModelData = PolymerResourcePackUtils.requestModel((Item)filledItem, (Identifier)new Identifier(id.getNamespace(), "item/" + id.getPath() + "_filled"));
        PolymerFoodContainerItem item = (PolymerFoodContainerItem)((Object)Registry.register((Registry)Registries.ITEM, (Identifier)id, (Object)((Object)new PolymerFoodContainerItem(new Item.Settings().maxCount(1).food(EMPTY_FOOD_COMPONENT), slots, screenHandlerType, emptyItem, filledItem, emptyModelData.value(), filledModelData.value()))));
        ItemGroupEvents.modifyEntriesEvent((RegistryKey)ItemGroups.FOOD_AND_DRINK).register(entries -> entries.add((ItemConvertible)item));
    }
}

