/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.server;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.container.FoodJournalScreenHandler;
import de.siphalor.spiceoffabric.container.FoodJournalView;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import java.util.Collection;
import java.util.Collections;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.command.argument.EntityArgumentType;
import net.minecraft.entity.attribute.EntityAttributeInstance;
import net.minecraft.entity.attribute.EntityAttributes;
import net.minecraft.screen.NamedScreenHandlerFactory;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.text.Text;

public class SOFCommands {
    private static final String AMOUNT_ARGUMENT = "amount";
    private static final String TARGETS_ARGUMENT = "targets";

    private SOFCommands() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, registryAccess, registrationEnvironment) -> {
            if (SOFConfig.enableJournalCommand) {
                commandDispatcher.register((LiteralArgumentBuilder)CommandManager.literal((String)"spiceoffabric:journal").executes(context -> SOFCommands.openJournal((ServerCommandSource)context.getSource())));
            }
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"spiceoffabric:clear_history").requires(source -> source.hasPermissionLevel(2))).executes(context -> SOFCommands.clearHistory((ServerCommandSource)context.getSource(), Collections.singleton(((ServerCommandSource)context.getSource()).getPlayer())))).then(CommandManager.argument((String)TARGETS_ARGUMENT, (ArgumentType)EntityArgumentType.players()).executes(context -> SOFCommands.clearHistory((ServerCommandSource)context.getSource(), EntityArgumentType.getPlayers((CommandContext)context, (String)TARGETS_ARGUMENT)))));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"spiceoffabric:set_base_max_health").requires(source -> source.hasPermissionLevel(2))).then(CommandManager.argument((String)TARGETS_ARGUMENT, (ArgumentType)EntityArgumentType.players()).then(CommandManager.argument((String)AMOUNT_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(context -> SOFCommands.setBaseMaxHealth((ServerCommandSource)context.getSource(), EntityArgumentType.getPlayers((CommandContext)context, (String)TARGETS_ARGUMENT), IntegerArgumentType.getInteger((CommandContext)context, (String)AMOUNT_ARGUMENT)))))).then(CommandManager.argument((String)AMOUNT_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(context -> SOFCommands.setBaseMaxHealth((ServerCommandSource)context.getSource(), Collections.singleton(((ServerCommandSource)context.getSource()).getPlayer()), IntegerArgumentType.getInteger((CommandContext)context, (String)AMOUNT_ARGUMENT)))));
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandManager.literal((String)"spiceoffabric:update_max_health").requires(source -> source.hasPermissionLevel(2))).executes(context -> SOFCommands.updateMaxHealth((ServerCommandSource)context.getSource(), Collections.singleton(((ServerCommandSource)context.getSource()).getPlayer())))).then(CommandManager.argument((String)TARGETS_ARGUMENT, (ArgumentType)EntityArgumentType.players()).executes(context -> SOFCommands.updateMaxHealth((ServerCommandSource)context.getSource(), EntityArgumentType.getPlayers((CommandContext)context, (String)TARGETS_ARGUMENT)))));
        });
    }

    private static int openJournal(ServerCommandSource commandSource) throws CommandSyntaxException {
        ServerPlayerEntity player = commandSource.getPlayer();
        player.openHandledScreen((NamedScreenHandlerFactory)new FoodJournalScreenHandler.Factory(player, FoodJournalView.getDefault()));
        return 1;
    }

    private static int clearHistory(ServerCommandSource commandSource, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            ((IHungerManager)player.getHungerManager()).spiceOfFabric_clearHistory();
            if (SOFConfig.carrot.enable) {
                SpiceOfFabric.updateMaxHealth(player, true, true);
            }
            if (SpiceOfFabric.hasClientMod(player)) {
                SOFCommonNetworking.sendClearFoodsPacket(player);
                player.sendMessage((Text)Text.translatable((String)"spiceoffabric.command.clear_history.was_cleared"), false);
                continue;
            }
            player.sendMessage((Text)Text.literal((String)"Your food history has been cleared"), false);
        }
        if (commandSource.getEntity() instanceof ServerPlayerEntity && SpiceOfFabric.hasClientMod(commandSource.getPlayer())) {
            commandSource.sendFeedback(() -> Text.translatable((String)"spiceoffabric.command.clear_history.cleared_players", (Object[])new Object[]{players.size()}), true);
        } else {
            commandSource.sendFeedback(() -> Text.literal((String)("Cleared food histories of " + players.size() + " players.")), true);
        }
        return players.size();
    }

    private static int setBaseMaxHealth(ServerCommandSource commandSource, Collection<ServerPlayerEntity> players, int amount) {
        for (ServerPlayerEntity player : players) {
            EntityAttributeInstance maxHealthAttr = player.getAttributeInstance(EntityAttributes.GENERIC_MAX_HEALTH);
            maxHealthAttr.setBaseValue((double)amount);
            if (SOFConfig.carrot.enable) {
                SpiceOfFabric.updateMaxHealth(player, true, true);
            }
            if (SpiceOfFabric.hasClientMod(player)) {
                player.sendMessage((Text)Text.translatable((String)"spiceoffabric.command.set_base_max_health.target"), false);
                continue;
            }
            player.sendMessage((Text)Text.literal((String)"Your health has been adjusted"), false);
        }
        if (commandSource.getEntity() instanceof ServerPlayerEntity && SpiceOfFabric.hasClientMod(commandSource.getPlayer())) {
            commandSource.sendFeedback(() -> Text.translatable((String)"spiceoffabric.command.set_base_max_health.executor", (Object[])new Object[]{players.size(), amount, (double)amount / 2.0}), false);
        } else {
            commandSource.sendFeedback(() -> Text.literal((String)"Set base health of %d players to %d (%s hearts)".formatted(players.size(), amount, (double)amount / 2.0)), false);
        }
        return players.size();
    }

    private static int updateMaxHealth(ServerCommandSource commandSource, Collection<ServerPlayerEntity> players) {
        boolean sourceHasMod = commandSource.getEntity() instanceof ServerPlayerEntity && SpiceOfFabric.hasClientMod(commandSource.getPlayer());
        for (ServerPlayerEntity player : players) {
            SpiceOfFabric.updateMaxHealth(player, true, true);
        }
        if (sourceHasMod) {
            commandSource.sendFeedback(() -> Text.translatable((String)"spiceoffabric.command.update_max_health.success", (Object[])new Object[]{players.size()}), false);
        } else {
            commandSource.sendFeedback(() -> Text.literal((String)("Refreshed the max health of " + players.size() + " players")), false);
        }
        return players.size();
    }
}

