/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.util;

import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.CakeBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtList;
import net.minecraft.nbt.NbtString;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FoodUtils {
    private static final String LAST_EATEN_BASE_TRANSLATION_KEY = "spiceoffabric.item.tooltip.last_eaten";
    private static final Text NEVER_EATEN_TOOLTIP = Text.translatable((String)"spiceoffabric.item.tooltip.never_eaten");

    private FoodUtils() {
    }

    public static boolean isFood(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof FoodContainerItem) {
            return false;
        }
        if (stack.isFood()) {
            return true;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock() instanceof CakeBlock;
        }
        return false;
    }

    public static boolean isFood(Item item) {
        if (item instanceof FoodContainerItem) {
            return false;
        }
        if (item.isFood()) {
            return true;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock() instanceof CakeBlock;
        }
        return false;
    }

    @Nullable
    public static ItemStack getFoodStack(FoodContext context) {
        Item item;
        ItemStack stack = context.stack();
        if (stack != null) {
            return stack;
        }
        BlockState blockState = context.blockState();
        if (blockState != null && (item = blockState.getBlock().asItem()) != null) {
            return new ItemStack((ItemConvertible)item);
        }
        return null;
    }

    public static void appendServerTooltips(PlayerEntity player, ItemStack stack) {
        NbtList loreNbt;
        if (!FoodUtils.isFood(stack)) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return;
        }
        ArrayList<Text> additions = new ArrayList<Text>();
        FoodUtils.appendCarrotTooltip(additions, stack, foodHistory);
        if (additions.isEmpty()) {
            return;
        }
        NbtCompound displayNbt = stack.getOrCreateSubNbt("display");
        if (displayNbt.contains("Lore", 9)) {
            loreNbt = displayNbt.getList("Lore", 8);
        } else {
            loreNbt = new NbtList();
            displayNbt.put("Lore", (NbtElement)loreNbt);
        }
        for (Text addition : additions) {
            loreNbt.add((Object)NbtString.of((String)Text.Serialization.toJsonString((Text)addition)));
        }
    }

    public static List<Text> getClientTooltipAdditions(PlayerEntity player, ItemStack stack) {
        if (!FoodUtils.isFood(stack)) {
            return Collections.emptyList();
        }
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return Collections.emptyList();
        }
        ArrayList<Text> additions = new ArrayList<Text>();
        FoodUtils.appendCarrotTooltip(additions, stack, foodHistory);
        FoodUtils.appendLastEatenTooltip(additions, stack, foodHistory);
        return additions;
    }

    private static void appendCarrotTooltip(List<Text> base, ItemStack stack, FoodHistory foodHistory) {
        if (SOFConfig.carrot.enable && !foodHistory.isInUniqueEaten(stack)) {
            base.add(NEVER_EATEN_TOOLTIP);
        }
    }

    private static void appendLastEatenTooltip(List<Text> base, ItemStack stack, FoodHistory foodHistory) {
        if (SOFConfig.showLastEatenTips == SOFConfig.ItemTipDisplayStyle.NONE || SOFConfig.food.historyLength <= 0) {
            return;
        }
        int lastEaten = foodHistory.getFoodCountSinceLastEaten(stack);
        if (lastEaten < 0) {
            return;
        }
        MutableText text = lastEaten == 0 ? Text.translatable((String)"spiceoffabric.item.tooltip.last_eaten.simple.last", (Object[])new Object[]{lastEaten}) : (lastEaten == 1 ? Text.translatable((String)"spiceoffabric.item.tooltip.last_eaten.simple.one", (Object[])new Object[]{lastEaten}) : Text.translatable((String)"spiceoffabric.item.tooltip.last_eaten.simple", (Object[])new Object[]{lastEaten}));
        if (SOFConfig.showLastEatenTips == SOFConfig.ItemTipDisplayStyle.EXTENDED) {
            int left = SOFConfig.food.historyLength - lastEaten;
            text = left == 1 ? Text.translatable((String)"spiceoffabric.item.tooltip.last_eaten.extended.one", (Object[])new Object[]{text, SOFConfig.food.historyLength - lastEaten}) : Text.translatable((String)"spiceoffabric.item.tooltip.last_eaten.extended", (Object[])new Object[]{text, SOFConfig.food.historyLength - lastEaten});
        }
        for (String line : StringUtils.split((String)text.getString(), (char)'\n')) {
            base.add((Text)Text.literal((String)line).styled(style -> style.withColor(Formatting.GRAY).withItalic(Boolean.valueOf(true))));
        }
    }
}

