package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.item.FoodContainerItem;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class FoodContainerScreenHandler extends class_1703 {
	private final FoodContainerItem foodContainerItem;

	public FoodContainerScreenHandler(FoodContainerItem foodContainerItem, int syncId, class_1661 playerInventory, class_1799 containerStack) {
		super(foodContainerItem.getScreenHandlerType(), syncId);
		this.foodContainerItem = foodContainerItem;

		ItemStackInventory inventory = foodContainerItem.getInventory(containerStack);
		for (int i = 0; i < foodContainerItem.getSize(); i++) {
			method_7621(new FoodSlot(inventory, i, 0, 0));
		}
		for (int i = 9; i < 36; i++) {
			method_7621(new class_1735(playerInventory, i, 0, 0));
		}
		for (int i = 0; i < 9; i++) {
			method_7621(new class_1735(playerInventory, i, 0, 0));
		}
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}

	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 result = class_1799.field_8037;
		class_1735 slot = this.field_7761.get(index);
		if (slot.method_7681()) {
			class_1799 moveStack = slot.method_7677();
			result = moveStack.method_7972();
			if (index < foodContainerItem.getSize()) {
				if (!this.method_7616(moveStack, foodContainerItem.getSize(), this.field_7761.size(), true)) {
					return class_1799.field_8037;
				}
			} else {
				if (!this.method_7616(moveStack, 0, foodContainerItem.getSize(), false)) {
					return class_1799.field_8037;
				}
			}
			if (moveStack.method_7960()) {
				slot.method_53512(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}
		return result;
	}

	private static class FoodSlot extends class_1735 {
		public FoodSlot(class_1263 inventory, int index, int x, int y) {
			super(inventory, index, x, y);
		}

		@Override
		public boolean method_7680(class_1799 stack) {
			return field_7871.method_5437(this.method_34266(), stack);
		}
	}

	public static class Factory implements class_3908 {
		private final class_1799 containerStack;
		private final FoodContainerItem foodContainerItem;

		public Factory(FoodContainerItem foodContainerItem, class_1799 containerStack) {
			this.containerStack = containerStack;
			this.foodContainerItem = foodContainerItem;
		}

		@Override
		public class_2561 method_5476() {
			return containerStack.method_7964();
		}

		@Nullable
		@Override
		public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
			return new FoodContainerScreenHandler(foodContainerItem, syncId, playerInventory, containerStack);
		}
	}
}
