package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.util.FoodUtils;
import de.siphalor.spiceoffabric.util.IHungerManager;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_7923;

public class FoodJournalScreenHandler extends class_1703 {
	private static final String PAGE_INDICATOR_TEXT_KEY = "book.pageIndicator";
	private static final class_1792 PAGE_INDICATOR_ITEM = class_1802.field_8600;
	private static final class_1799 PREV_STACK;
	private static final class_1799 NEXT_STACK;

	static {
		PREV_STACK = new class_1799(class_1802.field_8153);
		PREV_STACK.method_7977(class_2561.method_43471("createWorld.customize.custom.prev").method_27694(style -> style.method_10978(false)));
		NEXT_STACK = new class_1799(class_1802.field_8145);
		NEXT_STACK.method_7977(class_2561.method_43471("createWorld.customize.custom.next").method_27694(style -> style.method_10978(false)));
	}

	private static final int JOURNAL_SLOT_COUNT = 9 * 5;

	private final class_3222 player;
	private final boolean clientHasMod;
	private final FoodJournalView currentView;
	private final PaginatedReadOnlyInventory foodJournalInventory;
	private final class_1263 infoInventory;

	public FoodJournalScreenHandler(@Nullable class_3917<?> type, int syncId, FoodJournalView currentView, class_3222 player, FoodHistory foodHistory) {
		super(type, syncId);
		this.currentView = currentView;
		this.player = player;
		this.clientHasMod = SpiceOfFabric.hasClientMod(player);

		this.foodJournalInventory = createFoodJournalInventory(foodHistory, currentView);
		for (int i = 0; i < JOURNAL_SLOT_COUNT; i++) {
			method_7621(new ReadOnlySlot(foodJournalInventory, i, 0, 0));
		}

		this.infoInventory = new class_1277(
				class_1799.field_8037,
				class_1799.field_8037,
				class_1799.field_8037,
				PREV_STACK,
				createPageIndicatorStack(),
				NEXT_STACK,
				getViewStack(FoodJournalView.HISTORY, class_1802.field_8529),
				getViewStack(FoodJournalView.CARROT, class_1802.field_8695),
				getViewStack(FoodJournalView.CARROT_UNEATEN, class_1802.field_27022)
		);
		method_7621(new ReadOnlySlot(infoInventory, 0, 0, 0));
		method_7621(new ReadOnlySlot(infoInventory, 1, 0, 0));
		method_7621(new ReadOnlySlot(infoInventory, 2, 0, 0));
		method_7621(new ClickableSlot(infoInventory, 3, 0, 0, this::previousPage));
		method_7621(new ReadOnlySlot(infoInventory, 4, 0, 0));
		method_7621(new ClickableSlot(infoInventory, 5, 0, 0, this::nextPage));
		method_7621(new ClickableSlot(infoInventory, 6, 0, 0, getViewCallback(FoodJournalView.HISTORY)));
		method_7621(new ClickableSlot(infoInventory, 7, 0, 0, getViewCallback(FoodJournalView.CARROT)));
		method_7621(new ClickableSlot(infoInventory, 8, 0, 0, getViewCallback(FoodJournalView.CARROT_UNEATEN)));

		class_1661 playerInventory = player.method_31548();
		for (int i = 9; i < 36; i++) {
			method_7621(new class_1735(playerInventory, i, 0, 0));
		}
		for (int i = 0; i < 9; i++) {
			method_7621(new class_1735(playerInventory, i, 0, 0));
		}
	}

	private PaginatedReadOnlyInventory createFoodJournalInventory(FoodHistory foodHistory, FoodJournalView view) {
		if (view == FoodJournalView.HISTORY) {
			int historySize = foodHistory.getRecentlyEatenCount();
			var stacks = new ArrayList<class_1799>(historySize);
			for (int i = 0; i < historySize; i++) {
				stacks.add(foodHistory.getStackFromRecentlyEaten(i));
			}
			return new PaginatedReadOnlyInventory(JOURNAL_SLOT_COUNT, stacks);
		} else if (view == FoodJournalView.CARROT) {
			var stacks = foodHistory.getUniqueFoodsEaten().stream()
					.map(FoodHistoryEntry::getStack)
					.sorted(Comparator.comparingInt(stack -> {
						class_4174 foodComponent = stack.method_7909().method_19264();
						if (foodComponent == null) {
							return 0;
						}
						return foodComponent.method_19230();
					}))
					.toList();
			return new PaginatedReadOnlyInventory(JOURNAL_SLOT_COUNT, stacks);
		} else if (view == FoodJournalView.CARROT_UNEATEN) {
			var eatenItems = foodHistory.getUniqueFoodsEaten().stream()
					.map(entry -> entry.getStack().method_7909()).collect(Collectors.toUnmodifiableSet());
			var stacks = class_7923.field_41178.method_10220().parallel()
					.filter(FoodUtils::isFood)
					.filter(item -> !eatenItems.contains(item))
					.sorted(Comparator.comparingInt(item -> {
						class_4174 foodComponent = item.method_19264();
						if (foodComponent == null) {
							return 0;
						}
						return foodComponent.method_19230();
					}))
					.map(class_1799::new)
					.toList();
			return new PaginatedReadOnlyInventory(JOURNAL_SLOT_COUNT, stacks);
		} else {
			throw new IllegalStateException("Unrecognized view " + view + " during journal screen creation");
		}
	}

	private class_1799 createPageIndicatorStack() {
		var stack = new class_1799(PAGE_INDICATOR_ITEM);
		stack.method_7977(
				class_2561.method_43469(PAGE_INDICATOR_TEXT_KEY, foodJournalInventory.getPage() + 1, foodJournalInventory.getPageCount())
						.method_27694(style -> style.method_10978(false))
		);
		return stack;
	}

	private class_1799 getViewStack(FoodJournalView view, class_1792 itemRepresentation) {
		if (this.currentView == view || !view.isAvailable()) {
			return class_1799.field_8037;
		}
		return new class_1799(itemRepresentation)
				.method_7977(
						clientHasMod
								? view.getTranslatableName()
								: class_2561.method_43470(view.getLiteralName()).method_27694(style -> style.method_10978(false))
				);
	}

	private Runnable getViewCallback(FoodJournalView view) {
		if (!view.isAvailable()) {
			return () -> {
			};
		}
		return () -> player.method_17355(new Factory(player, view));
	}

	private void previousPage() {
		int page = foodJournalInventory.getPage();
		if (page > 0) {
			page--;
			foodJournalInventory.setPage(page);
			infoInventory.method_5447(4, createPageIndicatorStack());
			method_34252();
		}
	}

	private void nextPage() {
		int page = foodJournalInventory.getPage();
		if (page < foodJournalInventory.getPageCount() - 1) {
			page++;
			foodJournalInventory.setPage(page);
			infoInventory.method_5447(4, createPageIndicatorStack());
			method_34252();
		}
	}

	@Override
	public class_1799 method_7601(class_1657 player, int slot) {
		return class_1799.field_8037;
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}

	public static class Factory implements class_3908 {
		private final class_3222 player;
		private final FoodJournalView view;

		public Factory(class_3222 player, FoodJournalView view) {
			this.player = player;
			this.view = view;
		}

		@Override
		public class_2561 method_5476() {
			if (SpiceOfFabric.hasClientMod(player)) {
				return view.getTranslatableName();
			}
			return class_2561.method_43470(view.getLiteralName());
		}

		@Nullable
		@Override
		public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
			return new FoodJournalScreenHandler(class_3917.field_17327, syncId, view, this.player, ((IHungerManager) player.method_7344()).spiceOfFabric_getFoodHistory());
		}
	}
}
