package de.siphalor.spiceoffabric.container;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import java.util.Locale;
import net.minecraft.class_2561;

public enum FoodJournalView {
	HISTORY("Least to most recently eaten"),
	CARROT("All unique foods eaten so far"),
	CARROT_UNEATEN("Unique foods that have not been eaten yet")
	;

	private final class_2561 translatableName;
	private final String literalName;

	public static FoodJournalView getDefault() {
		if (HISTORY.isAvailable()) {
			return HISTORY;
		}
		if (CARROT.isAvailable()) {
			return CARROT;
		}
		return null;
	}

	FoodJournalView(String literalName) {
		this.translatableName = class_2561.method_43471(SpiceOfFabric.MOD_ID + ".journal.screen.view." + name().toLowerCase(Locale.ROOT))
				.method_27694(style -> style.method_10978(false));
		this.literalName = literalName;
	}

	public class_2561 getTranslatableName() {
		return translatableName;
	}

	public String getLiteralName() {
		return literalName;
	}

	public boolean isAvailable() {
		return switch (this) {
			case HISTORY -> SOFConfig.food.historyLength > 0;
			case CARROT -> SOFConfig.carrot.enable;
			case CARROT_UNEATEN -> SOFConfig.carrot.enable && SOFConfig.carrot.uneatenInJournal;
		};
	}
}
