package de.siphalor.spiceoffabric.mixin;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1702;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1702.class)
public abstract class MixinHungerManager implements IHungerManager {

	@Shadow public abstract void add(int int_1, float float_1);

	@Shadow private float saturationLevel;

	@Unique
	@Nullable
	protected class_3222 player = null;

	@Unique
	protected FoodHistory foodHistory = new FoodHistory();

	@Override
	public void spiceOfFabric_setPlayer(class_3222 serverPlayerEntity) {
		player = serverPlayerEntity;
	}

	@Override
	public void spiceOfFabric_clearHistory() {
		foodHistory.reset();
	}

	@Override
	public void spiceOfFabric_setSaturationLevel(float level) {
		saturationLevel = level;
	}

	@Override
	public FoodHistory spiceOfFabric_getFoodHistory() {
		return foodHistory;
	}

	@Override
	public void spiceOfFabric_setFoodHistory(FoodHistory foodHistory) {
		this.foodHistory = foodHistory;
	}

	@Inject(method = "readNbt", at = @At("RETURN"))
	public void onDeserialize(class_2487 data, CallbackInfo callbackInfo) {
		if(data.method_10573(SpiceOfFabric.NBT_FOOD_HISTORY_ID, 10)) {
			foodHistory = FoodHistory.read(data.method_10562(SpiceOfFabric.NBT_FOOD_HISTORY_ID));

			if (player != null && SOFConfig.carrot.enable) {
				class_1324 healthAttribute = player.method_5996(
						class_5134.field_23716
				);
				if (healthAttribute == null) {
					SpiceOfFabric.LOGGER.error("Players must have a maximum health!");
					return;
				}
				if (data.method_10545(SpiceOfFabric.NBT_VERSION_ID)) {
					class_1322 modifier = healthAttribute.method_6199(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
					if (modifier == null) {
						SpiceOfFabric.updateMaxHealth(player, false, false);
					}
				} else { // Migrate from old system
					healthAttribute.method_6200(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
					healthAttribute.method_6192(20D);
					healthAttribute.method_26837(new class_1322(
							SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID,
							SpiceOfFabric.MOD_ID,
							foodHistory.getCarrotHealthOffset(player),
							class_1322.class_1323.field_6328
					));
				}
			}
		}

		if (player != null) {
			((IServerPlayerEntity) player).spiceOfFabric_scheduleFoodHistorySync();
		}
	}

	@Inject(method = "writeNbt", at = @At("RETURN"))
	public void onSerialize(class_2487 data, CallbackInfo callbackInfo) {
		data.method_10566(SpiceOfFabric.NBT_FOOD_HISTORY_ID, foodHistory.write(new class_2487()));
		data.method_10566(SpiceOfFabric.NBT_VERSION_ID, class_2497.method_23247(SpiceOfFabric.NBT_VERSION));
	}
}
