package de.siphalor.spiceoffabric.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_3222.class, priority = 1100)
public abstract class MixinServerPlayerEntity extends class_1657 implements IServerPlayerEntity {
	@Shadow
	@Override
	public abstract void method_5702(class_2183.class_2184 anchorPoint, class_243 target);

	@Unique
	protected boolean foodHistorySync = false;
	@Unique
	protected long lastContainerEatTime;

	protected MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
		super(world, pos, yaw, gameProfile);
	}

	@Override
	public void spiceOfFabric_scheduleFoodHistorySync() {
		foodHistorySync = true;
	}

	@Override
	public boolean spiceOfFabric_foodHistorySync() {
		boolean result = foodHistorySync;
		foodHistorySync = false;
		return result;
	}

	@Override
	public long spiceOfFabric_getLastContainerEatTime() {
		return lastContainerEatTime;
	}

	@Override
	public void spiceOfFabric_setLastContainerEatTime(long time) {
		lastContainerEatTime = time;
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	public void onConstruct(MinecraftServer server, class_3218 world, GameProfile profile, class_8791 clientOptions, CallbackInfo ci) {
		((IHungerManager) field_7493).spiceOfFabric_setPlayer((class_3222) (Object) this);

		// Set the max health and health for new players
		// The max health for existing players will be overwritten when reading the nbt data
		SpiceOfFabric.updateMaxHealth((class_3222) (Object) this, false, false);
		method_6033(method_6063());
	}

	@Inject(method = "copyFrom", at = @At("RETURN"))
	public void onPlayerCopied(class_3222 reference, boolean exact, CallbackInfo callbackInfo) {
		if (exact) { // Teleporting back from the end
			((IHungerManager) field_7493).spiceOfFabric_setPlayer((class_3222) (Object) this);
			SpiceOfFabric.updateMaxHealth((class_3222) (Object) this, false, false);
			method_6033(reference.method_6032());
		} else { // Respawning
			Pair<Double, Double> respawnHunger = SOFConfig.getRespawnHunger(reference.method_7344().method_7586(), reference.method_7344().method_7589());
			field_7493.method_7580((int) Math.max(respawnHunger.getFirst(), reference.method_7344().method_7586()));
			((IHungerManager) field_7493).spiceOfFabric_setSaturationLevel((float) (double) respawnHunger.getSecond());

			FoodHistory foodHistory = ((IHungerManager) reference.method_7344()).spiceOfFabric_getFoodHistory();

			if (SOFConfig.respawn.resetHistory) {
				foodHistory.resetHistory();
			}
			if (SOFConfig.carrot.enable && SOFConfig.respawn.resetCarrotMode) {
				foodHistory.resetUniqueFoodsEaten();
			}

			((IHungerManager) field_7493).spiceOfFabric_setFoodHistory(foodHistory);

			SOFCommonNetworking.syncFoodHistory((class_3222) (Object) this);
			SpiceOfFabric.updateMaxHealth((class_3222) (Object) this, false, false);
			method_6033(method_6063());
		}
	}

	@Inject(method = "readCustomDataFromNbt", at = @At("TAIL"))
	public void afterReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
		// Update the max health. This overwrites the base definition in the constructor
		// and older data that has been read from the player nbt.
		SpiceOfFabric.updateMaxHealth((class_3222) (Object) this, false, false);

		if (nbt.method_10573("Health", 99)) {
			this.method_6033(nbt.method_10583("Health"));
		}
	}
}
