package de.siphalor.spiceoffabric.networking;

import de.siphalor.spiceoffabric.foodhistory.FoodHistoryEntry;
import de.siphalor.spiceoffabric.util.IHungerManager;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class SOFClientNetworking extends SOFCommonNetworking {
	private static class_2540 lastSyncPacket;

	private SOFClientNetworking() {}

	public static void init() {
		ClientPlayConnectionEvents.JOIN.register(SOFClientNetworking::onJoined);
		ClientPlayNetworking.registerGlobalReceiver(SYNC_FOOD_HISTORY_S2C_PACKET, SOFClientNetworking::onFoodHistorySyncPacketReceived);
		ClientPlayNetworking.registerGlobalReceiver(ADD_FOOD_S2C_PACKET, SOFClientNetworking::onAddFoodPacketReceived);
		ClientPlayNetworking.registerGlobalReceiver(CLEAR_FOODS_S2C_PACKET, SOFClientNetworking::onClearFoodPackedReceived);
	}

	private static void onJoined(class_634 handler, PacketSender sender, class_310 client) {
		assert client.field_1724 != null;
		if (lastSyncPacket != null) {
			((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_getFoodHistory().read(lastSyncPacket);
			lastSyncPacket.release();
			lastSyncPacket = null;
		}
	}

	private static void onFoodHistorySyncPacketReceived(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
		if (client.field_1724 != null && client.field_1724.method_7344() != null) {
			((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_getFoodHistory().read(buf);
		} else {
			lastSyncPacket = new class_2540(buf.copy());
			lastSyncPacket.method_52938();
		}
	}

	private static void onAddFoodPacketReceived(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
		((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_getFoodHistory().addFood(FoodHistoryEntry.from(buf));
	}

	private static void onClearFoodPackedReceived(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
		((IHungerManager) client.field_1724.method_7344()).spiceOfFabric_clearHistory();
	}

}
