package de.siphalor.spiceoffabric.polymer;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.util.FoodUtils;
import eu.pb4.polymer.core.api.client.ClientPolymerItem;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.item.*;

public class SOFPolymer {
	private static final class_4174 EMPTY_FOOD_COMPONENT = new class_4174.class_4175().method_19242();

	private SOFPolymer() {
	}

	public static void init() {
		PolymerItemUtils.ITEM_CHECK.register(class_1799::method_19267);

		PolymerItemUtils.ITEM_MODIFICATION_EVENT.register((original, client, player) -> {
			if (!SpiceOfFabric.hasClientMod(player)) {
				FoodUtils.appendServerTooltips(player, client);
			}
			return client;
		});

		PolymerResourcePackUtils.addModAssets(SpiceOfFabric.MOD_ID);

		if (SOFConfig.items.enablePaperBag) {
			registerFoodContainer("paper_bag", class_1802.field_8407, class_1802.field_8567, 5, class_3917.field_17337);
		}
		if (SOFConfig.items.enableLunchBox) {
			registerFoodContainer("lunch_box", class_1802.field_8138, class_1802.field_8423, 9, class_3917.field_17328);
		}
		if (SOFConfig.items.enablePicnicBasket) {
			registerFoodContainer("picnic_basket", class_1802.field_8533, class_1802.field_8229, 9, class_3917.field_17328);
		}
	}

	public static void registerFoodContainer(String idPath, class_1792 emptyItem, class_1792 filledItem, int slots, class_3917<?> screenHandlerType) {
		class_2960 id = new class_2960(SpiceOfFabric.MOD_ID, idPath);
		PolymerModelData emptyModelData = PolymerResourcePackUtils.requestModel(emptyItem, new class_2960(id.method_12836(), "item/" + id.method_12832() + "_empty"));
		PolymerModelData filledModelData = PolymerResourcePackUtils.requestModel(filledItem, new class_2960(id.method_12836(), "item/" + id.method_12832() + "_filled"));
		PolymerFoodContainerItem item = class_2378.method_10230(class_7923.field_41178, id, new PolymerFoodContainerItem(
				new class_1792.class_1793().method_7889(1).method_19265(EMPTY_FOOD_COMPONENT),
				slots, screenHandlerType,
				emptyItem, filledItem, emptyModelData.value(), filledModelData.value()
		));
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(entries -> entries.method_45421(item));
	}
}
