package de.siphalor.spiceoffabric.server;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.container.FoodJournalScreenHandler;
import de.siphalor.spiceoffabric.container.FoodJournalView;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1324;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import java.util.Collection;
import java.util.Collections;

public class SOFCommands {
	private static final String AMOUNT_ARGUMENT = "amount";
	private static final String TARGETS_ARGUMENT = "targets";

	private SOFCommands() {}

	public static void register() {
		CommandRegistrationCallback.EVENT.register((commandDispatcher, registryAccess, registrationEnvironment) -> {
			if (SOFConfig.enableJournalCommand) {
				commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":journal")
						.executes(context -> openJournal(context.getSource())));
			}
			commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":clear_history")
					.requires(source -> source.method_9259(2))
					.executes(context ->
							clearHistory(
									context.getSource(),
									Collections.singleton(context.getSource().method_44023())
							)
					).then(
							class_2170.method_9244(TARGETS_ARGUMENT, class_2186.method_9308())
									.executes(context ->
											clearHistory(
													context.getSource(),
													class_2186.method_9312(context, TARGETS_ARGUMENT)
											)
									)
					)
			);
			commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":set_base_max_health")
					.requires(source -> source.method_9259(2))
					.then(
							class_2170.method_9244(TARGETS_ARGUMENT, class_2186.method_9308())
									.then(
											class_2170.method_9244(AMOUNT_ARGUMENT, IntegerArgumentType.integer(1, 200))
													.executes(context ->
															setBaseMaxHealth(
																	context.getSource(),
																	class_2186.method_9312(context, TARGETS_ARGUMENT),
																	IntegerArgumentType.getInteger(context, AMOUNT_ARGUMENT)
															)
													)
									)
					)
					.then(
							class_2170.method_9244(AMOUNT_ARGUMENT, IntegerArgumentType.integer(1, 200))
									.executes(context ->
											setBaseMaxHealth(
													context.getSource(),
													Collections.singleton(context.getSource().method_44023()),
													IntegerArgumentType.getInteger(context, AMOUNT_ARGUMENT)
											)
									)
					)
			);
			commandDispatcher.register(class_2170.method_9247(SpiceOfFabric.MOD_ID + ":update_max_health")
					.requires(source -> source.method_9259(2))
					.executes(context ->
							updateMaxHealth(context.getSource(), Collections.singleton(context.getSource().method_44023()))
					).then(
							class_2170.method_9244(TARGETS_ARGUMENT, class_2186.method_9308())
									.executes(context ->
											updateMaxHealth(context.getSource(), class_2186.method_9312(context, TARGETS_ARGUMENT))
									)
					)
			);
		});
	}

	private static int openJournal(class_2168 commandSource) throws CommandSyntaxException {
		class_3222 player = commandSource.method_44023();
		player.method_17355(new FoodJournalScreenHandler.Factory(player, FoodJournalView.getDefault()));
		return 1;
	}

	private static int clearHistory(class_2168 commandSource, Collection<class_3222> players) {
		for (class_3222 player : players) {
			((IHungerManager) player.method_7344()).spiceOfFabric_clearHistory();
			if (SOFConfig.carrot.enable) {
				SpiceOfFabric.updateMaxHealth(player, true, true);
			}
			if (SpiceOfFabric.hasClientMod(player)) {
				SOFCommonNetworking.sendClearFoodsPacket(player);
				player.method_7353(class_2561.method_43471("spiceoffabric.command.clear_history.was_cleared"), false);
			} else {
				player.method_7353(class_2561.method_43470("Your food history has been cleared"), false);
			}
		}

		if (commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasClientMod(commandSource.method_44023())) {
			commandSource.method_9226(() -> class_2561.method_43469("spiceoffabric.command.clear_history.cleared_players", players.size()), true);
		} else {
			commandSource.method_9226(() -> class_2561.method_43470("Cleared food histories of " + players.size() + " players."), true);
		}
		return players.size();
	}

	private static int setBaseMaxHealth(class_2168 commandSource, Collection<class_3222> players, int amount) {
		for (class_3222 player : players) {
			class_1324 maxHealthAttr = player.method_5996(class_5134.field_23716);
			//noinspection ConstantConditions
			maxHealthAttr.method_6192(amount);
			if (SOFConfig.carrot.enable) {
				SpiceOfFabric.updateMaxHealth(player, true, true);
			}
			if (SpiceOfFabric.hasClientMod(player)) {
				player.method_7353(class_2561.method_43471("spiceoffabric.command.set_base_max_health.target"), false);
			} else {
				player.method_7353(class_2561.method_43470("Your health has been adjusted"), false);
			}
		}

		if (commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasClientMod(commandSource.method_44023())) {
			commandSource.method_9226(() -> class_2561.method_43469("spiceoffabric.command.set_base_max_health.executor", players.size(), amount, amount / 2D), false);
		} else {
			commandSource.method_9226(() -> class_2561.method_43470("Set base health of %d players to %d (%s hearts)".formatted(players.size(), amount, amount / 2D)), false);
		}
		return players.size();
	}

	private static int updateMaxHealth(class_2168 commandSource, Collection<class_3222> players) {
		boolean sourceHasMod = commandSource.method_9228() instanceof class_3222 && SpiceOfFabric.hasClientMod(commandSource.method_44023());

		for (class_3222 player : players) {
			SpiceOfFabric.updateMaxHealth(player, true, true);
		}
		if (sourceHasMod) {
			commandSource.method_9226(() -> class_2561.method_43469("spiceoffabric.command.update_max_health.success", players.size()), false);
		} else {
			commandSource.method_9226(() -> class_2561.method_43470("Refreshed the max health of " + players.size() + " players"), false);
		}
		return players.size();
	}
}
