package de.siphalor.spiceoffabric.util;

import de.siphalor.capsaicin.api.food.FoodContext;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.item.FoodContainerItem;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2272;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class FoodUtils {
	private static final String LAST_EATEN_BASE_TRANSLATION_KEY = SpiceOfFabric.MOD_ID + ".item.tooltip.last_eaten";
	private static final class_2561 NEVER_EATEN_TOOLTIP = class_2561.method_43471(SpiceOfFabric.MOD_ID + ".item.tooltip.never_eaten");

	private FoodUtils() {
	}

	public static boolean isFood(class_1799 stack) {
		class_1792 item = stack.method_7909();
		if (item instanceof FoodContainerItem) {
			return false;
		}
		if (stack.method_19267()) {
			return true;
		}
		if (item instanceof class_1747 blockItem) {
			return blockItem.method_7711() instanceof class_2272;
		}
		return false;
	}

	public static boolean isFood(class_1792 item) {
		if (item instanceof FoodContainerItem) {
			return false;
		}
		if (item.method_19263()) {
			return true;
		}
		if (item instanceof class_1747 blockItem) {
			return blockItem.method_7711() instanceof class_2272;
		}
		return false;
	}

	public static @Nullable class_1799 getFoodStack(FoodContext context) {
		class_1799 stack = context.stack();
		if (stack != null) {
			return stack;
		}
		class_2680 blockState = context.blockState();
		if (blockState != null) {
			class_1792 item = blockState.method_26204().method_8389();
			if (item != null) {
				return new class_1799(item);
			}
		}
		return null;
	}

	public static void appendServerTooltips(class_1657 player, class_1799 stack) {
		if (!isFood(stack)) {
			return;
		}
		FoodHistory foodHistory = FoodHistory.get(player);
		if (foodHistory == null) {
			return;
		}

		var additions = new ArrayList<class_2561>();
		appendCarrotTooltip(additions, stack, foodHistory);
		if (additions.isEmpty()) {
			return;
		}

		class_2487 displayNbt = stack.method_7911(class_1799.field_30893);
		class_2499 loreNbt;
		if (displayNbt.method_10573(class_1799.field_30895, 9)) {
			loreNbt = displayNbt.method_10554(class_1799.field_30895, 8);
		} else {
			loreNbt = new class_2499();
			displayNbt.method_10566(class_1799.field_30895, loreNbt);
		}

		for (class_2561 addition : additions) {
			loreNbt.add(class_2519.method_23256(class_2561.class_2562.method_10867(addition)));
		}
	}

	public static List<class_2561> getClientTooltipAdditions(class_1657 player, class_1799 stack) {
		if (!isFood(stack)) {
			return Collections.emptyList();
		}
		FoodHistory foodHistory = FoodHistory.get(player);
		if (foodHistory == null) {
			return Collections.emptyList();
		}

		var additions = new ArrayList<class_2561>();
		appendCarrotTooltip(additions, stack, foodHistory);
		appendLastEatenTooltip(additions, stack, foodHistory);

		return additions;
	}

	private static void appendCarrotTooltip(List<class_2561> base, class_1799 stack, FoodHistory foodHistory) {
		if (SOFConfig.carrot.enable && !foodHistory.isInUniqueEaten(stack)) {
			base.add(NEVER_EATEN_TOOLTIP);
		}
	}

	private static void appendLastEatenTooltip(List<class_2561> base, class_1799 stack, FoodHistory foodHistory) {
		if (SOFConfig.showLastEatenTips == SOFConfig.ItemTipDisplayStyle.NONE || SOFConfig.food.historyLength <= 0) {
			return;
		}
		int lastEaten = foodHistory.getFoodCountSinceLastEaten(stack);
		if (lastEaten < 0) {
			return;
		}

		class_2561 text;
		if (lastEaten == 0) {
			text = class_2561.method_43469(LAST_EATEN_BASE_TRANSLATION_KEY + ".simple.last", lastEaten);
		} else if (lastEaten == 1) {
			text = class_2561.method_43469(LAST_EATEN_BASE_TRANSLATION_KEY + ".simple.one", lastEaten);
		} else {
			text = class_2561.method_43469(LAST_EATEN_BASE_TRANSLATION_KEY + ".simple", lastEaten);
		}

		if (SOFConfig.showLastEatenTips == SOFConfig.ItemTipDisplayStyle.EXTENDED) {
			int left = SOFConfig.food.historyLength - lastEaten;
			if (left == 1) {
				text = class_2561.method_43469(LAST_EATEN_BASE_TRANSLATION_KEY + ".extended.one", text, SOFConfig.food.historyLength - lastEaten);
			} else {
				text = class_2561.method_43469(LAST_EATEN_BASE_TRANSLATION_KEY + ".extended", text, SOFConfig.food.historyLength - lastEaten);
			}
		}

		for (String line : StringUtils.split(text.getString(), '\n')) {
			base.add(class_2561.method_43470(line).method_27694(style -> style.method_10977(class_124.field_1080).method_10978(true)));
		}
	}
}
